/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class DoubleConversions {
    private DoubleConversions() {
    }

    static @NonNull Boolean doubleToBoolean(@NonNull Double d) {
        return d != 0.0;
    }

    static @Nullable UByte doubleToByte(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 255L) {
            return Unsigned.ubyte((long)rounded);
        }
        return null;
    }

    static @Nullable Float doubleToFloat(@NonNull Double d) {
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return Float.valueOf(d.floatValue());
        }
        return null;
    }

    static @Nullable Short doubleToInt16(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= -32768L && rounded <= 32767L) {
            return (short)rounded;
        }
        return null;
    }

    static @Nullable Integer doubleToInt32(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= Integer.MIN_VALUE && rounded <= Integer.MAX_VALUE) {
            return (int)rounded;
        }
        return null;
    }

    static @Nullable Long doubleToInt64(@NonNull Double d) {
        if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
            return Math.round(d);
        }
        return null;
    }

    static @Nullable Byte doubleToSByte(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= -128L && rounded <= 127L) {
            return (byte)rounded;
        }
        return null;
    }

    static @NonNull String doubleToString(@NonNull Double d) {
        return d.toString();
    }

    static @Nullable UShort doubleToUInt16(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 65535L) {
            return Unsigned.ushort((int)((int)rounded));
        }
        return null;
    }

    static @Nullable UInteger doubleToUInt32(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 0xFFFFFFFFL) {
            return Unsigned.uint((long)rounded);
        }
        return null;
    }

    static @Nullable ULong doubleToUInt64(@NonNull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L) {
            return Unsigned.ulong((long)rounded);
        }
        return null;
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Double) {
            Double d = (Double)o;
            return implicit ? DoubleConversions.implicitConversion(d, targetType) : DoubleConversions.explicitConversion(d, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Double d, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return DoubleConversions.doubleToBoolean(d);
            }
            case Byte: {
                return DoubleConversions.doubleToByte(d);
            }
            case Float: {
                return DoubleConversions.doubleToFloat(d);
            }
            case Int16: {
                return DoubleConversions.doubleToInt16(d);
            }
            case Int32: {
                return DoubleConversions.doubleToInt32(d);
            }
            case Int64: {
                return DoubleConversions.doubleToInt64(d);
            }
            case SByte: {
                return DoubleConversions.doubleToSByte(d);
            }
            case String: {
                return DoubleConversions.doubleToString(d);
            }
            case UInt16: {
                return DoubleConversions.doubleToUInt16(d);
            }
            case UInt32: {
                return DoubleConversions.doubleToUInt32(d);
            }
            case UInt64: {
                return DoubleConversions.doubleToUInt64(d);
            }
        }
        return DoubleConversions.implicitConversion(d, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Double d, OpcUaDataType targetType) {
        return null;
    }
}

