/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.Nullable;

public class ServiceOperationContext<T>
implements AccessContext {
    private final OpcUaServer server;
    private final Session session;
    private final DiagnosticsContext<T> diagnosticsContext;
    private final String auditEntryId;
    private final UInteger timeoutHint;
    private final ExtensionObject additionalHeader;

    public ServiceOperationContext(OpcUaServer server, @Nullable Session session) {
        this(server, session, new DiagnosticsContext(), "", Unsigned.uint((int)0), null);
    }

    public ServiceOperationContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<T> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
        this.server = server;
        this.session = session;
        this.diagnosticsContext = diagnosticsContext;
        this.auditEntryId = auditEntryId;
        this.timeoutHint = timeoutHint;
        this.additionalHeader = additionalHeader;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    @Override
    public Optional<Session> getSession() {
        return Optional.ofNullable(this.session);
    }

    public DiagnosticsContext<T> getDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    public @Nullable String getAuditEntryId() {
        return this.auditEntryId;
    }

    public UInteger getTimeoutHint() {
        return this.timeoutHint;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }
}

