/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.server.EndpointConfig;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.RoleMapper;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public interface OpcUaServerConfig {
    public static final UserTokenPolicy USER_TOKEN_POLICY_ANONYMOUS = new UserTokenPolicy("anonymous", UserTokenType.Anonymous, null, null, null);
    public static final UserTokenPolicy USER_TOKEN_POLICY_USERNAME = new UserTokenPolicy("username", UserTokenType.UserName, null, null, SecurityPolicy.Basic256Sha256.getUri());
    public static final UserTokenPolicy USER_TOKEN_POLICY_X509 = new UserTokenPolicy("certificate", UserTokenType.Certificate, null, null, SecurityPolicy.Basic256Sha256.getUri());

    public Set<EndpointConfig> getEndpoints();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public BuildInfo getBuildInfo();

    public IdentityValidator getIdentityValidator();

    public EncodingLimits getEncodingLimits();

    public OpcUaServerConfigLimits getLimits();

    public CertificateManager getCertificateManager();

    public Optional<RoleMapper> getRoleMapper();

    public ExecutorService getExecutor();

    public ScheduledExecutorService getScheduledExecutorService();

    public static OpcUaServerConfigBuilder builder() {
        return new OpcUaServerConfigBuilder();
    }

    public static OpcUaServerConfigBuilder copy(OpcUaServerConfig config) {
        OpcUaServerConfigBuilder builder = new OpcUaServerConfigBuilder();
        builder.setEndpoints(config.getEndpoints());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setBuildInfo(config.getBuildInfo());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setLimits(config.getLimits());
        builder.setIdentityValidator(config.getIdentityValidator());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setExecutor(config.getExecutor());
        builder.setScheduledExecutor(config.getScheduledExecutorService());
        return builder;
    }

    public static OpcUaServerConfig copy(OpcUaServerConfig config, Consumer<OpcUaServerConfigBuilder> consumer) {
        OpcUaServerConfigBuilder builder = OpcUaServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

