/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.shaded.com.google.common.base.MoreObjects;
import org.eclipse.milo.shaded.com.google.common.base.Objects;
import org.jspecify.annotations.Nullable;

public class EndpointConfig {
    private final TransportProfile transportProfile;
    private final String bindAddress;
    private final int bindPort;
    private final String hostname;
    private final String path;
    private final Supplier<X509Certificate> certificateSupplier;
    private final SecurityPolicy securityPolicy;
    private final MessageSecurityMode securityMode;
    private final List<UserTokenPolicy> tokenPolicies;

    private EndpointConfig(TransportProfile transportProfile, String bindAddress, int bindPort, String hostname, String path, Supplier<X509Certificate> certificateSupplier, SecurityPolicy securityPolicy, MessageSecurityMode securityMode, List<UserTokenPolicy> tokenPolicies) {
        this.transportProfile = transportProfile;
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.hostname = hostname;
        this.path = path;
        this.certificateSupplier = certificateSupplier;
        this.securityPolicy = securityPolicy;
        this.securityMode = securityMode;
        this.tokenPolicies = List.copyOf(tokenPolicies);
    }

    public TransportProfile getTransportProfile() {
        return this.transportProfile;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPath() {
        return this.path;
    }

    public @Nullable X509Certificate getCertificate() {
        return this.certificateSupplier.get();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public List<UserTokenPolicy> getTokenPolicies() {
        return this.tokenPolicies;
    }

    public String getEndpointUrl() {
        String scheme = this.transportProfile.getScheme();
        String p = this.path.isEmpty() || this.path.startsWith("/") ? this.path : "/" + this.path;
        return String.format("%s://%s:%s%s", scheme, this.hostname, this.bindPort, p);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointConfig that = (EndpointConfig)o;
        return this.bindPort == that.bindPort && this.transportProfile == that.transportProfile && Objects.equal((Object)this.bindAddress, (Object)that.bindAddress) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.getCertificate(), (Object)that.getCertificate()) && this.securityPolicy == that.securityPolicy && this.securityMode == that.securityMode && Objects.equal(this.tokenPolicies, that.tokenPolicies);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.transportProfile, this.bindAddress, this.bindPort, this.hostname, this.path, this.getCertificate(), this.securityPolicy, this.securityMode, this.tokenPolicies});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transportProfile", (Object)this.transportProfile).add("bindAddress", (Object)this.bindAddress).add("bindPort", this.bindPort).add("hostname", (Object)this.hostname).add("path", (Object)this.path).add("certificate", (Object)this.getCertificate()).add("securityPolicy", (Object)this.securityPolicy).add("securityMode", (Object)this.securityMode).add("tokenPolicies", this.tokenPolicies).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        static final UserTokenPolicy USER_TOKEN_POLICY_ANONYMOUS = new UserTokenPolicy("anonymous", UserTokenType.Anonymous, null, null, null);
        TransportProfile transportProfile = TransportProfile.TCP_UASC_UABINARY;
        String bindAddress = "localhost";
        int bindPort = 12685;
        String hostname = "localhost";
        String path = "";
        Supplier<X509Certificate> certificateSupplier = () -> null;
        SecurityPolicy securityPolicy = SecurityPolicy.None;
        MessageSecurityMode securityMode = MessageSecurityMode.None;
        List<UserTokenPolicy> tokenPolicies = new ArrayList<UserTokenPolicy>();

        public Builder setTransportProfile(TransportProfile transportProfile) {
            this.transportProfile = transportProfile;
            return this;
        }

        public Builder setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder setBindPort(int bindPort) {
            this.bindPort = bindPort;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setCertificate(@Nullable X509Certificate certificate) {
            this.certificateSupplier = () -> certificate;
            return this;
        }

        public Builder setCertificate(Supplier<X509Certificate> certificateSupplier) {
            this.certificateSupplier = certificateSupplier;
            return this;
        }

        public Builder setSecurityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        public Builder setSecurityMode(MessageSecurityMode securityMode) {
            this.securityMode = securityMode;
            return this;
        }

        public Builder addTokenPolicy(UserTokenPolicy tokenPolicy) {
            this.tokenPolicies.add(tokenPolicy);
            return this;
        }

        public Builder addTokenPolicies(UserTokenPolicy ... tokenPolicies) {
            Collections.addAll(this.tokenPolicies, tokenPolicies);
            return this;
        }

        private Builder addTokenPolicies(List<UserTokenPolicy> tokenPolicies) {
            this.tokenPolicies.addAll(tokenPolicies);
            return this;
        }

        public Builder copy() {
            return new Builder().setTransportProfile(this.transportProfile).setBindAddress(this.bindAddress).setBindPort(this.bindPort).setHostname(this.hostname).setPath(this.path).setCertificate(this.certificateSupplier).setSecurityPolicy(this.securityPolicy).setSecurityMode(this.securityMode).addTokenPolicies(this.tokenPolicies);
        }

        public EndpointConfig build() {
            if (this.securityPolicy != SecurityPolicy.None || this.securityMode != MessageSecurityMode.None) {
                if (this.securityPolicy == SecurityPolicy.None) {
                    throw new IllegalArgumentException("securityPolicy: " + String.valueOf(this.securityPolicy));
                }
                if (this.securityMode == MessageSecurityMode.None) {
                    throw new IllegalArgumentException("securityMode: " + String.valueOf(this.securityMode));
                }
                if (this.certificateSupplier.get() == null) {
                    throw new IllegalStateException("security requires certificate");
                }
            }
            switch (this.transportProfile) {
                case HTTPS_UAXML: 
                case HTTPS_UAJSON: 
                case WSS_UASC_UABINARY: 
                case WSS_UAJSON: {
                    throw new IllegalArgumentException("unsupported transport: " + String.valueOf(this.transportProfile));
                }
            }
            List<UserTokenPolicy> tokenPolicies = this.tokenPolicies;
            if (tokenPolicies.isEmpty()) {
                tokenPolicies.add(USER_TOKEN_POLICY_ANONYMOUS);
            }
            return new EndpointConfig(this.transportProfile, this.bindAddress, this.bindPort, this.hostname, this.path, this.certificateSupplier, this.securityPolicy, this.securityMode, tokenPolicies);
        }
    }
}

