/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.binary.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.Matrix;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.jspecify.annotations.Nullable;

public class AttributeReader {
    public static DataValue readAttribute(AccessContext context, UaServerNode node, UInteger attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName encodingName) {
        return AttributeId.from((UInteger)attributeId).map(id -> AttributeReader.readAttribute(context, node, id, timestamps, indexRange, encodingName)).orElseGet(() -> new DataValue(2150957056L));
    }

    public static DataValue readAttribute(AccessContext context, UaServerNode node, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName encodingName) {
        Object value;
        if (!AttributeId.getAttributes((NodeClass)node.getNodeClass()).contains(attributeId)) {
            return new DataValue(2150957056L);
        }
        if (encodingName != null && encodingName.isNotNull()) {
            NodeId dataTypeId;
            if (attributeId != AttributeId.Value) {
                return new DataValue(0x80380000L);
            }
            if (node instanceof VariableNode) {
                dataTypeId = ((VariableNode)node).getDataType();
            } else if (node instanceof VariableTypeNode) {
                dataTypeId = ((VariableTypeNode)node).getDataType();
            } else {
                return new DataValue(0x80380000L);
            }
            if (!AttributeReader.isStructureSubtype(node.getNodeContext().getServer(), dataTypeId)) {
                return new DataValue(0x80380000L);
            }
        }
        try {
            value = node.readAttribute(context, attributeId);
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
        if (attributeId == AttributeId.Value) {
            DataValue dv = (DataValue)value;
            DataValue.Builder dvb = dv.copy();
            if (encodingName != null && encodingName.isNotNull() && dv.value().isNotNull()) {
                Object valueObject = dvb.value.value();
                Class<?> valueClazz = valueObject.getClass();
                if (valueClazz.isArray() && ArrayUtil.getType((Object)valueObject) == ExtensionObject.class) {
                    Object newValue = ArrayUtil.transformArray((Object)valueObject, xo -> AttributeReader.transcode(node, xo, encodingName), ExtensionObject.class);
                    dvb.setValue(new Variant(newValue));
                } else if (ExtensionObject.class.isAssignableFrom(valueClazz)) {
                    ExtensionObject xo2 = (ExtensionObject)valueObject;
                    ExtensionObject newValue = AttributeReader.transcode(node, xo2, encodingName);
                    dvb.setValue(new Variant((Object)newValue));
                }
            }
            if (indexRange != null && !indexRange.isEmpty()) {
                try {
                    Object valueAtRange;
                    NumericRange range = NumericRange.parse((String)indexRange);
                    Object object = dv.value().value();
                    if (object instanceof Matrix) {
                        Matrix matrix = (Matrix)object;
                        valueAtRange = NumericRange.readFromValueAtRange((Object)matrix.nestedArrayValue(), (NumericRange)range);
                        if (ArrayUtil.getValueRank((Object)valueAtRange) > 1) {
                            valueAtRange = new Matrix(valueAtRange);
                        }
                    } else {
                        valueAtRange = NumericRange.readFromValueAtRange((Variant)dv.value(), (NumericRange)range);
                    }
                    return dvb.setValue(Variant.of((Object)valueAtRange)).applyTimestamps(attributeId, timestamps).build();
                }
                catch (UaException e) {
                    return new DataValue(e.getStatusCode());
                }
            }
            return dvb.applyTimestamps(attributeId, timestamps).build();
        }
        switch (attributeId) {
            case DataTypeDefinition: {
                DataType dataType;
                StructureDefinition definition;
                NodeId defaultEncodingId;
                if (value instanceof StructureDefinition && (defaultEncodingId = (definition = (StructureDefinition)value).getDefaultEncodingId()).isNull() && (dataType = node.getNodeContext().getServer().getDataTypeTree().getDataType(node.getNodeId())) != null && dataType.getBinaryEncodingId() != null) {
                    value = new StructureDefinition(dataType.getBinaryEncodingId(), definition.getBaseDataType(), definition.getStructureType(), definition.getFields());
                }
            }
            case RolePermissions: 
            case UserRolePermissions: 
            case AccessRestrictions: 
            case AccessLevelEx: 
            case InverseName: {
                if (value != null) break;
                return new DataValue(2150957056L);
            }
        }
        if (indexRange != null && !indexRange.isEmpty()) {
            try {
                NumericRange range = NumericRange.parse((String)indexRange);
                value = NumericRange.readFromValueAtRange((Object)value, (NumericRange)range);
            }
            catch (UaException e) {
                return new DataValue(e.getStatusCode());
            }
        }
        return DataValue.newValue().setValue(Variant.of((Object)value)).setStatus(StatusCode.GOOD).applyTimestamps(attributeId, timestamps).build();
    }

    private static boolean isStructureSubtype(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            Optional superTypeId = dataTypeNode.getReferences().stream().filter(r -> r.isInverse() && r.getReferenceTypeId().equals((Object)NodeIds.HasSubtype)).flatMap(r -> r.getTargetNodeId().toNodeId(server.getNamespaceTable()).stream()).findFirst();
            return superTypeId.map(id -> id.equals((Object)NodeIds.Structure) || AttributeReader.isStructureSubtype(server, id)).orElse(false);
        }
        return false;
    }

    private static ExtensionObject transcode(UaServerNode node, ExtensionObject xo, QualifiedName encodingName) {
        if (xo == null || xo.isNull()) {
            return xo;
        }
        if (encodingName == null || encodingName.isNull()) {
            encodingName = OpcUaDefaultBinaryEncoding.ENCODING_NAME;
        }
        Object newEncoding = OpcUaDefaultBinaryEncoding.ENCODING_NAME.equals((Object)encodingName) ? OpcUaDefaultBinaryEncoding.getInstance() : node.getNodeContext().getServer().getEncodingManager().getEncoding(encodingName);
        NodeId newEncodingId = AttributeReader.getEncodingId(node, encodingName);
        if (newEncodingId != null) {
            return xo.transcode(node.getNodeContext().getServer().getStaticEncodingContext(), newEncodingId, (DataTypeEncoding)newEncoding);
        }
        return xo;
    }

    private static @Nullable NodeId getEncodingId(UaServerNode node, QualifiedName encodingName) {
        NodeId dataTypeId;
        if (node instanceof VariableNode) {
            dataTypeId = ((VariableNode)node).getDataType();
        } else if (node instanceof VariableTypeNode) {
            dataTypeId = ((VariableTypeNode)node).getDataType();
        } else {
            return null;
        }
        AddressSpaceManager addressSpaceManager = node.getNodeContext().getServer().getAddressSpaceManager();
        UaNode dataTypeNode = addressSpaceManager.getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(r -> r.isForward() && NodeIds.HasEncoding.equals((Object)r.getReferenceTypeId())).flatMap(r -> addressSpaceManager.getManagedNode(r.getTargetNodeId()).stream()).filter(n -> encodingName.equals((Object)n.getBrowseName())).map(Node::getNodeId).findFirst().orElse(null);
        }
        return null;
    }
}

