/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceComposite;
import org.eclipse.milo.opcua.sdk.server.NodeManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSpaceManager
extends AddressSpaceComposite {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<NodeManager<UaNode>> nodeManagers = new CopyOnWriteArrayList<NodeManager<UaNode>>();

    public AddressSpaceManager(OpcUaServer server) {
        super(server);
    }

    public synchronized void register(NodeManager<UaNode> nodeManager) {
        if (!this.nodeManagers.contains(nodeManager)) {
            this.nodeManagers.add(nodeManager);
        } else {
            this.logger.warn("NodeManager already registered: {}", nodeManager);
        }
    }

    public synchronized void unregister(NodeManager<UaNode> nodeManager) {
        if (this.nodeManagers.contains(nodeManager)) {
            this.nodeManagers.remove(nodeManager);
        } else {
            this.logger.warn("NodeManager not registered: {}", nodeManager);
        }
    }

    public Optional<UaNode> getManagedNode(NodeId nodeId) {
        return this.nodeManagers.stream().filter(n -> n.containsNode(nodeId)).findFirst().flatMap(n -> n.getNode(nodeId));
    }

    public Optional<UaNode> getManagedNode(ExpandedNodeId nodeId) {
        return nodeId.toNodeId(this.getServer().getNamespaceTable()).flatMap(this::getManagedNode);
    }

    public List<Reference> getManagedReferences(NodeId nodeId) {
        return this.nodeManagers.stream().map(n -> n.getReferences(nodeId)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Reference> getManagedReferences(NodeId nodeId, Predicate<Reference> filter) {
        return this.nodeManagers.stream().map(n -> n.getReferences(nodeId, filter)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

