/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceFragment;
import org.eclipse.milo.opcua.sdk.server.ManagedAddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SimpleAddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.EventItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSpaceComposite
implements AddressSpaceFragment {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CopyOnWriteArrayList<AddressSpaceFragment> addressSpaces = new CopyOnWriteArrayList();
    private final CompositeAddressSpaceFilter filter = new CompositeAddressSpaceFilter(this.addressSpaces);
    private final OpcUaServer server;

    public AddressSpaceComposite(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public AddressSpaceFilter getFilter() {
        return this.filter;
    }

    public synchronized void register(AddressSpaceFragment addressSpace) {
        if (!this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.add(addressSpace);
            this.logger.debug("registered {}", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace already registered: {}", (Object)addressSpace);
        }
    }

    public synchronized void registerFirst(AddressSpaceFragment addressSpace) {
        if (!this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.add(0, addressSpace);
            this.logger.debug("registered {} at index 0", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace already registered: {}", (Object)addressSpace);
        }
    }

    public synchronized void unregister(AddressSpaceFragment addressSpace) {
        if (this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.remove(addressSpace);
            this.logger.debug("unregistered {}", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace not registered: {}", (Object)addressSpace);
        }
    }

    protected OpcUaServer getServer() {
        return this.server;
    }

    protected List<AddressSpaceFragment> getAddressSpaces() {
        return new ArrayList<AddressSpaceFragment>(this.addressSpaces);
    }

    private AddressSpaceFragment getAddressSpace(Predicate<AddressSpaceFragment> filter) {
        return this.addressSpaces.stream().filter(filter).findFirst().orElse(new EmptyAddressSpaceFragment(this.server));
    }

    @Override
    public List<AddressSpace.ReferenceResult> browse(AddressSpace.BrowseContext context, ViewDescription view, List<NodeId> nodeIds) {
        List initialResults = GroupMapCollate.groupMapCollate(nodeIds, nodeId -> this.getAddressSpace(asx -> asx.getFilter().filterBrowse(this.server, (NodeId)nodeId)), asx -> group -> {
            AddressSpace.BrowseContext ctx = new AddressSpace.BrowseContext(this.server, context.getSession().orElse(null));
            return asx.browse(ctx, view, (List<NodeId>)group);
        });
        ArrayList<AddressSpace.ReferenceResult> finalResults = new ArrayList<AddressSpace.ReferenceResult>();
        for (int i = 0; i < initialResults.size(); ++i) {
            NodeId nodeId2 = nodeIds.get(i);
            AddressSpace.ReferenceResult initialResult = (AddressSpace.ReferenceResult)initialResults.get(i);
            if (initialResult instanceof AddressSpace.ReferenceResult.ReferenceList) {
                AddressSpace.ReferenceResult.ReferenceList rl = (AddressSpace.ReferenceResult.ReferenceList)initialResult;
                LinkedHashSet<Reference> references = new LinkedHashSet<Reference>(rl.references());
                AddressSpace.BrowseContext browseContext = new AddressSpace.BrowseContext(this.getServer(), context.getSession().orElse(null));
                AddressSpaceFragment first = this.getAddressSpace(asx -> asx.getFilter().filterBrowse(this.server, nodeId2));
                for (AddressSpace addressSpace : this.addressSpaces) {
                    if (addressSpace == first) continue;
                    AddressSpace.ReferenceResult.ReferenceList gatherResult = addressSpace.gather(browseContext, view, nodeId2);
                    references.addAll(gatherResult.references());
                }
                finalResults.add(AddressSpace.ReferenceResult.of(new ArrayList<Reference>(references)));
                continue;
            }
            finalResults.add(initialResult);
        }
        return finalResults;
    }

    @Override
    public AddressSpace.ReferenceResult.ReferenceList gather(AddressSpace.BrowseContext context, ViewDescription view, NodeId nodeId) {
        ArrayList referenceStreams = new ArrayList();
        for (AddressSpace addressSpace : this.addressSpaces) {
            AddressSpace.BrowseContext browseContext = new AddressSpace.BrowseContext(this.server, context.getSession().orElse(null));
            AddressSpace.ReferenceResult.ReferenceList result = addressSpace.gather(browseContext, view, nodeId);
            referenceStreams.add(result.references().stream());
        }
        List<Reference> references = referenceStreams.stream().flatMap(Function.identity()).distinct().toList();
        return AddressSpace.ReferenceResult.of(references);
    }

    @Override
    public List<NodeId> registerNodes(AddressSpace.RegisterNodesContext context, List<NodeId> nodeIds) {
        return GroupMapCollate.groupMapCollate(nodeIds, nodeId -> this.getAddressSpace(asx -> asx.getFilter().filterRegisterNode(this.server, (NodeId)nodeId)), asx -> group -> {
            AddressSpace.RegisterNodesContext ctx = new AddressSpace.RegisterNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.registerNodes(ctx, (List<NodeId>)group);
        });
    }

    @Override
    public void unregisterNodes(AddressSpace.UnregisterNodesContext context, List<NodeId> nodeIds) {
        GroupMapCollate.groupMapCollate(nodeIds, nodeId -> this.getAddressSpace(asx -> asx.getFilter().filterUnregisterNode(this.server, (NodeId)nodeId)), asx -> group -> {
            AddressSpace.UnregisterNodesContext ctx = new AddressSpace.UnregisterNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            asx.unregisterNodes(ctx, (List<NodeId>)group);
            return Collections.nCopies(group.size(), Unit.VALUE);
        });
    }

    @Override
    public UInteger getViewCount() {
        return this.addressSpaces.stream().map(AddressSpace::getViewCount).reduce(Unsigned.uint((int)0), UInteger::add);
    }

    @Override
    public List<DataValue> read(AddressSpace.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        return GroupMapCollate.groupMapCollate(readValueIds, readValueId -> this.getAddressSpace(asx -> asx.getFilter().filterRead(this.server, (ReadValueId)readValueId)), asx -> group -> {
            AddressSpace.ReadContext ctx = new AddressSpace.ReadContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.read(ctx, maxAge, timestamps, (List<ReadValueId>)group);
        });
    }

    @Override
    public List<StatusCode> write(AddressSpace.WriteContext context, List<WriteValue> writeValues) {
        return GroupMapCollate.groupMapCollate(writeValues, writeValue -> this.getAddressSpace(asx -> asx.getFilter().filterWrite(this.server, (WriteValue)writeValue)), asx -> group -> {
            AddressSpace.WriteContext ctx = new AddressSpace.WriteContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.write(ctx, (List<WriteValue>)group);
        });
    }

    @Override
    public List<HistoryReadResult> historyRead(AddressSpace.HistoryReadContext context, HistoryReadDetails details, TimestampsToReturn timestamps, List<HistoryReadValueId> readValueIds) {
        return GroupMapCollate.groupMapCollate(readValueIds, readValueId -> this.getAddressSpace(asx -> asx.getFilter().filterHistoryRead(this.server, (HistoryReadValueId)readValueId)), asx -> group -> {
            AddressSpace.HistoryReadContext ctx = new AddressSpace.HistoryReadContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.historyRead(ctx, details, timestamps, (List<HistoryReadValueId>)group);
        });
    }

    @Override
    public List<HistoryUpdateResult> historyUpdate(AddressSpace.HistoryUpdateContext context, List<HistoryUpdateDetails> updateDetailsList) {
        return GroupMapCollate.groupMapCollate(updateDetailsList, updateDetails -> this.getAddressSpace(asx -> asx.getFilter().filterHistoryUpdate(this.server, (HistoryUpdateDetails)updateDetails)), asx -> group -> {
            AddressSpace.HistoryUpdateContext ctx = new AddressSpace.HistoryUpdateContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.historyUpdate(ctx, (List<HistoryUpdateDetails>)group);
        });
    }

    @Override
    public List<CallMethodResult> call(AddressSpace.CallContext context, List<CallMethodRequest> requests) {
        return GroupMapCollate.groupMapCollate(requests, request -> this.getAddressSpace(asx -> asx.getFilter().filterCall(this.server, (CallMethodRequest)request)), asx -> group -> {
            AddressSpace.CallContext ctx = new AddressSpace.CallContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.call(ctx, (List<CallMethodRequest>)group);
        });
    }

    @Override
    public AddressSpace.RevisedDataItemParameters onCreateDataItem(ReadValueId itemToMonitor, Double requestedSamplingInterval, UInteger requestedQueueSize) {
        AddressSpaceFragment addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnCreateDataItem(this.server, itemToMonitor));
        return addressSpace.onCreateDataItem(itemToMonitor, requestedSamplingInterval, requestedQueueSize);
    }

    @Override
    public AddressSpace.RevisedDataItemParameters onModifyDataItem(ReadValueId itemToModify, Double requestedSamplingInterval, UInteger requestedQueueSize) {
        AddressSpaceFragment addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnModifyDataItem(this.server, itemToModify));
        return addressSpace.onModifyDataItem(itemToModify, requestedSamplingInterval, requestedQueueSize);
    }

    @Override
    public AddressSpace.RevisedEventItemParameters onCreateEventItem(ReadValueId itemToMonitor, UInteger requestedQueueSize) {
        AddressSpaceFragment addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnCreateEventItem(this.server, itemToMonitor));
        return addressSpace.onCreateEventItem(itemToMonitor, requestedQueueSize);
    }

    @Override
    public AddressSpace.RevisedEventItemParameters onModifyEventItem(ReadValueId itemToModify, UInteger requestedQueueSize) {
        AddressSpaceFragment addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnModifyEventItem(this.server, itemToModify));
        return addressSpace.onModifyEventItem(itemToModify, requestedQueueSize);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsCreated(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onDataItemsCreated);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsModified(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onDataItemsModified);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsDeleted(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onDataItemsDeleted);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsCreated(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onEventItemsCreated);
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsModified(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onEventItemsModified);
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsDeleted(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onEventItemsDeleted);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        Map<AddressSpace, List<MonitoredItem>> byAddressSpace = monitoredItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnMonitoringModeChanged(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(AddressSpace::onMonitoringModeChanged);
    }

    @Override
    public List<AddNodesResult> addNodes(AddressSpace.AddNodesContext context, List<AddNodesItem> nodesToAdd) {
        return GroupMapCollate.groupMapCollate(nodesToAdd, addNodesItem -> this.getAddressSpace(asx -> asx.getFilter().filterAddNodes(this.server, (AddNodesItem)addNodesItem)), asx -> group -> {
            AddressSpace.AddNodesContext ctx = new AddressSpace.AddNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.addNodes(ctx, (List<AddNodesItem>)group);
        });
    }

    @Override
    public List<StatusCode> deleteNodes(AddressSpace.DeleteNodesContext context, List<DeleteNodesItem> nodesToDelete) {
        return GroupMapCollate.groupMapCollate(nodesToDelete, deleteNodesItem -> this.getAddressSpace(asx -> asx.getFilter().filterDeleteNodes(this.server, (DeleteNodesItem)deleteNodesItem)), asx -> group -> {
            AddressSpace.DeleteNodesContext ctx = new AddressSpace.DeleteNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.deleteNodes(ctx, (List<DeleteNodesItem>)group);
        });
    }

    @Override
    public List<StatusCode> addReferences(AddressSpace.AddReferencesContext context, List<AddReferencesItem> referencesToAdd) {
        return GroupMapCollate.groupMapCollate(referencesToAdd, addReferencesItem -> this.getAddressSpace(asx -> asx.getFilter().filterAddReferences(this.server, (AddReferencesItem)addReferencesItem)), asx -> group -> {
            AddressSpace.AddReferencesContext ctx = new AddressSpace.AddReferencesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.addReferences(ctx, (List<AddReferencesItem>)group);
        });
    }

    @Override
    public List<StatusCode> deleteReferences(AddressSpace.DeleteReferencesContext context, List<DeleteReferencesItem> referencesToDelete) {
        return GroupMapCollate.groupMapCollate(referencesToDelete, deleteReferencesItem -> this.getAddressSpace(asx -> asx.getFilter().filterDeleteReferences(this.server, (DeleteReferencesItem)deleteReferencesItem)), asx -> group -> {
            AddressSpace.DeleteReferencesContext ctx = new AddressSpace.DeleteReferencesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext(), context.getAuditEntryId(), context.getTimeoutHint(), context.getAdditionalHeader());
            return asx.deleteReferences(ctx, (List<DeleteReferencesItem>)group);
        });
    }

    private static class CompositeAddressSpaceFilter
    implements AddressSpaceFilter {
        private final List<AddressSpaceFragment> addressSpaces;

        CompositeAddressSpaceFilter(List<AddressSpaceFragment> addressSpaces) {
            this.addressSpaces = addressSpaces;
        }

        @Override
        public boolean filterBrowse(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterBrowse(server, nodeId));
        }

        @Override
        public boolean filterRegisterNode(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterRegisterNode(server, nodeId));
        }

        @Override
        public boolean filterUnregisterNode(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterUnregisterNode(server, nodeId));
        }

        @Override
        public boolean filterRead(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterRead(server, readValueId));
        }

        @Override
        public boolean filterWrite(OpcUaServer server, WriteValue writeValue) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterWrite(server, writeValue));
        }

        @Override
        public boolean filterHistoryRead(OpcUaServer server, HistoryReadValueId historyReadValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterHistoryRead(server, historyReadValueId));
        }

        @Override
        public boolean filterHistoryUpdate(OpcUaServer server, HistoryUpdateDetails historyUpdateDetails) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterHistoryUpdate(server, historyUpdateDetails));
        }

        @Override
        public boolean filterCall(OpcUaServer server, CallMethodRequest callMethodRequest) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterCall(server, callMethodRequest));
        }

        @Override
        public boolean filterOnCreateDataItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnCreateDataItem(server, readValueId));
        }

        @Override
        public boolean filterOnModifyDataItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnModifyDataItem(server, readValueId));
        }

        @Override
        public boolean filterOnCreateEventItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnCreateEventItem(server, readValueId));
        }

        @Override
        public boolean filterOnModifyEventItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnModifyEventItem(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsCreated(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsCreated(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsModified(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsModified(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsDeleted(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsCreated(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsCreated(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsModified(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsModified(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsDeleted(server, readValueId));
        }

        @Override
        public boolean filterOnMonitoringModeChanged(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnMonitoringModeChanged(server, readValueId));
        }

        @Override
        public boolean filterAddNodes(OpcUaServer server, AddNodesItem addNodesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterAddNodes(server, addNodesItem));
        }

        @Override
        public boolean filterDeleteNodes(OpcUaServer server, DeleteNodesItem deleteNodesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterDeleteNodes(server, deleteNodesItem));
        }

        @Override
        public boolean filterAddReferences(OpcUaServer server, AddReferencesItem addReferencesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterAddReferences(server, addReferencesItem));
        }

        @Override
        public boolean filterDeleteReferences(OpcUaServer server, DeleteReferencesItem deleteReferencesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterDeleteReferences(server, deleteReferencesItem));
        }
    }

    private static class EmptyAddressSpaceFragment
    extends ManagedAddressSpace
    implements AddressSpaceFragment {
        EmptyAddressSpaceFragment(OpcUaServer server) {
            super(server);
        }

        @Override
        public AddressSpaceFilter getFilter() {
            return new SimpleAddressSpaceFilter(){

                @Override
                protected boolean filterNode(NodeId nodeId) {
                    return true;
                }

                @Override
                protected boolean filterMonitoredItem(NodeId nodeId) {
                    return true;
                }
            };
        }

        @Override
        public void onDataItemsCreated(List<DataItem> dataItems) {
        }

        @Override
        public void onDataItemsModified(List<DataItem> dataItems) {
        }

        @Override
        public void onDataItemsDeleted(List<DataItem> dataItems) {
        }

        @Override
        public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        }
    }
}

