/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.typetree;

import java.util.List;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceType;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.ReferenceTypes;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;

public class ReferenceTypeTreeBuilder {
    public static ReferenceTypeTree build(OpcUaServer server) {
        UaNode rootNode = server.getAddressSpaceManager().getManagedNode(NodeIds.References).orElseThrow();
        Tree tree = new Tree(null, (Object)new ServerReferenceType(null, (UaReferenceTypeNode)rootNode));
        ReferenceTypeTreeBuilder.addChildren((Tree<ReferenceType>)tree, server);
        return new ReferenceTypeTree(tree);
    }

    private static void addChildren(Tree<ReferenceType> tree, OpcUaServer server) {
        NodeId nodeId = ((ReferenceType)tree.getValue()).getNodeId();
        List<Reference> references = server.getAddressSpaceManager().getManagedReferences(nodeId, r -> r.isForward() && r.getReferenceTypeId().equals((Object)ReferenceTypes.HasSubtype));
        List childNodes = references.stream().flatMap(r -> server.getAddressSpaceManager().getManagedNode(r.getTargetNodeId()).stream()).toList();
        childNodes.forEach(node -> {
            if (node instanceof ReferenceTypeNode) {
                Tree childTree = tree.addChild((Object)new ServerReferenceType(nodeId, (ReferenceTypeNode)node));
                ReferenceTypeTreeBuilder.addChildren((Tree<ReferenceType>)childTree, server);
            }
        });
    }

    private static class ServerReferenceType
    implements ReferenceType {
        private final @Nullable NodeId parentNodeId;
        private final ReferenceTypeNode node;

        private ServerReferenceType(@Nullable NodeId parentNodeId, ReferenceTypeNode node) {
            this.parentNodeId = parentNodeId;
            this.node = node;
        }

        public ReferenceTypeNode getNode() {
            return this.node;
        }

        public NodeId getNodeId() {
            return this.node.getNodeId();
        }

        public QualifiedName getBrowseName() {
            return this.node.getBrowseName();
        }

        public Optional<String> getInverseName() {
            String name = this.node.getInverseName().text();
            return Optional.ofNullable(name);
        }

        public boolean isSymmetric() {
            return this.node.getSymmetric();
        }

        public boolean isAbstract() {
            return this.node.getIsAbstract();
        }

        public Optional<NodeId> getSupertypeId() {
            return Optional.ofNullable(this.parentNodeId);
        }
    }
}

