/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers.BrowseUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.Lists;

public class BrowsePathsHelper {
    private final AccessContext context;
    private final OpcUaServer server;

    public BrowsePathsHelper(AccessContext context, OpcUaServer server) {
        this.context = context;
        this.server = server;
    }

    public TranslateBrowsePathsToNodeIdsResponse translateBrowsePaths(TranslateBrowsePathsToNodeIdsRequest request) throws UaException {
        List browsePaths = Lists.ofNullable((Object[])request.getBrowsePaths());
        if (browsePaths.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (browsePaths.size() > this.server.getConfig().getLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue()) {
            throw new UaException(0x80100000L);
        }
        ArrayList<BrowsePathResult> results = new ArrayList<BrowsePathResult>(browsePaths.size());
        for (BrowsePath browsePath : browsePaths) {
            results.add(this.translate(browsePath));
        }
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new TranslateBrowsePathsToNodeIdsResponse(header, (BrowsePathResult[])results.toArray(BrowsePathResult[]::new), new DiagnosticInfo[0]);
    }

    private BrowsePathResult translate(BrowsePath browsePath) {
        NodeId startingNode = browsePath.getStartingNode();
        RelativePath relativePath = browsePath.getRelativePath();
        if (startingNode.isNull()) {
            return new BrowsePathResult(new StatusCode(0x80330000L), new BrowsePathTarget[0]);
        }
        List relativePathElements = Lists.ofNullable((Object[])relativePath.getElements());
        if (relativePathElements.isEmpty()) {
            return new BrowsePathResult(new StatusCode(0x800F0000L), new BrowsePathTarget[0]);
        }
        try {
            List<BrowsePathTarget> targets = this.follow(startingNode, relativePathElements);
            if (!targets.isEmpty()) {
                return new BrowsePathResult(StatusCode.GOOD, targets.toArray(new BrowsePathTarget[0]));
            }
            return new BrowsePathResult(new StatusCode(2154758144L), new BrowsePathTarget[0]);
        }
        catch (UaException e) {
            return new BrowsePathResult(e.getStatusCode(), new BrowsePathTarget[0]);
        }
    }

    private List<BrowsePathTarget> follow(NodeId nodeId, List<RelativePathElement> elements) throws UaException {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (elements.size() == 1) {
            List<ExpandedNodeId> targets = this.target(nodeId, elements.get(0));
            return targets.stream().map(n -> {
                n = BrowseUtil.normalize(n, this.server.getNamespaceTable());
                return new BrowsePathTarget(n, UInteger.MAX);
            }).collect(Collectors.toList());
        }
        RelativePathElement e = elements.get(0);
        ExpandedNodeId nextXni = this.next(nodeId, e);
        if (nextXni.isNull()) {
            throw new UaException(2154758144L);
        }
        List<RelativePathElement> nextElements = elements.subList(1, elements.size());
        Optional nextId = nextXni.toNodeId(this.server.getNamespaceTable());
        if (nextId.isPresent()) {
            return this.follow((NodeId)nextId.get(), nextElements);
        }
        UInteger remaining = nextElements.isEmpty() ? UInteger.MAX : Unsigned.uint((int)nextElements.size());
        nextXni = BrowseUtil.normalize(nextXni, this.server.getNamespaceTable());
        return List.of(new BrowsePathTarget(nextXni, remaining));
    }

    private ExpandedNodeId next(NodeId nodeId, RelativePathElement element) throws UaException {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        if (targetName.isNull()) {
            throw new UaException(0x80600000L);
        }
        AddressSpace.BrowseContext browseContext = new AddressSpace.BrowseContext(this.server, this.context.getSession().orElse(null));
        ViewDescription view = new ViewDescription(NodeId.NULL_VALUE, DateTime.NULL_VALUE, UInteger.valueOf((int)0));
        AddressSpace.ReferenceResult result = this.server.getAddressSpaceManager().browse(browseContext, view, List.of(nodeId)).get(0);
        if (result instanceof AddressSpace.ReferenceResult.ReferenceList) {
            AddressSpace.ReferenceResult.ReferenceList rl = (AddressSpace.ReferenceResult.ReferenceList)result;
            List<Reference> references = rl.references();
            ReferenceTypeTree referenceTypeTree = this.server.getReferenceTypeTree();
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && referenceTypeTree.isSubtypeOf(r.getReferenceTypeId(), referenceTypeId)).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            if (targetNodeIds.isEmpty()) {
                throw new UaException(2154758144L);
            }
            List<QualifiedName> browseNames = this.readTargetBrowseNames(targetNodeIds);
            for (int i = 0; i < targetNodeIds.size(); ++i) {
                ExpandedNodeId targetNodeId = targetNodeIds.get(i);
                QualifiedName browseName = browseNames.get(i);
                if (!browseName.equals((Object)targetName)) continue;
                return targetNodeId;
            }
            return ExpandedNodeId.NULL_VALUE;
        }
        throw new UaException(2150891520L);
    }

    private List<ExpandedNodeId> target(NodeId nodeId, RelativePathElement element) throws UaException {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        if (targetName.isNull()) {
            throw new UaException(0x80600000L);
        }
        AddressSpace.BrowseContext browseContext = new AddressSpace.BrowseContext(this.server, this.context.getSession().orElse(null));
        ViewDescription view = new ViewDescription(NodeId.NULL_VALUE, DateTime.NULL_VALUE, UInteger.valueOf((int)0));
        AddressSpace.ReferenceResult result = this.server.getAddressSpaceManager().browse(browseContext, view, List.of(nodeId)).get(0);
        if (result instanceof AddressSpace.ReferenceResult.ReferenceList) {
            AddressSpace.ReferenceResult.ReferenceList rl = (AddressSpace.ReferenceResult.ReferenceList)result;
            List<Reference> references = rl.references();
            ReferenceTypeTree referenceTypeTree = this.server.getReferenceTypeTree();
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && referenceTypeTree.isSubtypeOf(r.getReferenceTypeId(), referenceTypeId)).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            if (targetNodeIds.isEmpty()) {
                throw new UaException(2154758144L);
            }
            List<QualifiedName> browseNames = this.readTargetBrowseNames(targetNodeIds);
            ArrayList<ExpandedNodeId> targets = new ArrayList<ExpandedNodeId>();
            for (int i = 0; i < targetNodeIds.size(); ++i) {
                ExpandedNodeId targetNodeId = targetNodeIds.get(i);
                QualifiedName browseName = browseNames.get(i);
                if (!this.matchesTarget(browseName, targetName)) continue;
                targets.add(targetNodeId);
            }
            return targets;
        }
        throw new UaException(2150891520L);
    }

    private List<QualifiedName> readTargetBrowseNames(List<ExpandedNodeId> targetNodeIds) {
        ArrayList<QualifiedName> browseNames = new ArrayList<QualifiedName>();
        for (ExpandedNodeId xni : targetNodeIds) {
            try {
                NodeId nodeId = xni.toNodeIdOrThrow(this.server.getNamespaceTable());
                ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE);
                AddressSpace.ReadContext context = new AddressSpace.ReadContext(this.server, null);
                List<DataValue> values = this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, List.of(readValueId));
                browseNames.add((QualifiedName)values.get(0).value().value());
            }
            catch (Exception ignored) {
                browseNames.add(QualifiedName.NULL_VALUE);
            }
        }
        return browseNames;
    }

    private boolean matchesTarget(QualifiedName browseName, QualifiedName targetName) {
        return targetName == null || targetName.equals((Object)QualifiedName.NULL_VALUE) || targetName.equals((Object)browseName);
    }
}

