/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;

public final class AttributeFilterContext {
    private volatile boolean observable = false;
    private final Session session;
    private final UaNode node;
    private final Iterator<AttributeFilter> filterIterator;

    public AttributeFilterContext(Session session, UaNode node, Iterator<AttributeFilter> filterIterator) {
        this.session = session;
        this.node = node;
        this.filterIterator = filterIterator;
    }

    public UaNode getNode() {
        return this.node;
    }

    public Optional<Session> getSession() {
        return Optional.ofNullable(this.session);
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public Object getAttribute(AttributeId attributeId) {
        AttributeFilter next = this.nextAttributeFilter();
        return next.getAttribute(this, attributeId);
    }

    public Object readAttribute(AttributeId attributeId) throws UaException {
        AttributeFilter next = this.nextAttributeFilter();
        return next.readAttribute(this, attributeId);
    }

    public void setAttribute(AttributeId attributeId, Object value) {
        AttributeFilter next = this.nextAttributeFilter();
        next.setAttribute(this, attributeId, value);
    }

    public void writeAttribute(AttributeId attributeId, Object value) throws UaException {
        AttributeFilter next = this.nextAttributeFilter();
        next.writeAttribute(this, attributeId, value);
    }

    private AttributeFilter nextAttributeFilter() {
        return this.filterIterator.hasNext() ? this.filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
    }
}

