/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.nodes.DefaultAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.jspecify.annotations.Nullable;

public class AttributeFilterChain {
    private volatile @Nullable ConcurrentLinkedDeque<AttributeFilter> filterDeque = null;

    public AttributeFilterChain() {
    }

    public AttributeFilterChain(AttributeFilter filter) {
        this.filterDeque = new ConcurrentLinkedDeque();
        Objects.requireNonNull(this.filterDeque).add(filter);
    }

    public AttributeFilterChain(List<AttributeFilter> filters) {
        this.filterDeque = new ConcurrentLinkedDeque();
        Objects.requireNonNull(this.filterDeque).addAll(filters);
    }

    public Object getAttribute(UaNode node, AttributeId attributeId) {
        return this.getAttribute(null, node, attributeId);
    }

    public Object getAttribute(@Nullable Session session, UaNode node, AttributeId attributeId) {
        ConcurrentLinkedDeque<AttributeFilter> filters = this.filterDeque;
        if (filters == null || filters.isEmpty()) {
            return node.getAttribute(attributeId);
        }
        Iterator<AttributeFilter> filterIterator = filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? (AttributeFilter)filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext ctx = new AttributeFilterContext(session, node, filterIterator);
        Object value = filter.getAttribute(ctx, attributeId);
        if (ctx.isObservable()) {
            node.fireAttributeChanged(attributeId, value);
        }
        return value;
    }

    public Object readAttribute(@Nullable Session session, UaNode node, AttributeId attributeId) throws UaException {
        ConcurrentLinkedDeque<AttributeFilter> filters = this.filterDeque;
        if (filters == null || filters.isEmpty()) {
            return node.getAttribute(attributeId);
        }
        Iterator<AttributeFilter> filterIterator = filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? (AttributeFilter)filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext ctx = new AttributeFilterContext(session, node, filterIterator);
        Object value = filter.readAttribute(ctx, attributeId);
        if (ctx.isObservable()) {
            node.fireAttributeChanged(attributeId, value);
        }
        return value;
    }

    public void setAttribute(UaNode node, AttributeId attributeId, Object value) {
        this.setAttribute(null, node, attributeId, value);
    }

    public void setAttribute(@Nullable Session session, UaNode node, AttributeId attributeId, Object value) {
        ConcurrentLinkedDeque<AttributeFilter> filters = this.filterDeque;
        if (filters == null || filters.isEmpty()) {
            node.setAttribute(attributeId, value);
            return;
        }
        Iterator<AttributeFilter> filterIterator = filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? (AttributeFilter)filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext ctx = new AttributeFilterContext(session, node, filterIterator);
        filter.setAttribute(ctx, attributeId, value);
    }

    public void writeAttribute(@Nullable Session session, UaNode node, AttributeId attributeId, Object value) throws UaException {
        ConcurrentLinkedDeque<AttributeFilter> filters = this.filterDeque;
        if (filters == null || filters.isEmpty()) {
            node.setAttribute(attributeId, value);
            return;
        }
        Iterator<AttributeFilter> filterIterator = filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? (AttributeFilter)filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext ctx = new AttributeFilterContext(session, node, filterIterator);
        filter.writeAttribute(ctx, attributeId, value);
    }

    public synchronized AttributeFilterChain addFirst(AttributeFilter attributeFilter) {
        if (this.filterDeque == null) {
            this.filterDeque = new ConcurrentLinkedDeque();
        }
        Objects.requireNonNull(this.filterDeque).addFirst(attributeFilter);
        return this;
    }

    public synchronized AttributeFilterChain addFirst(AttributeFilter ... attributeFilters) {
        Arrays.stream(attributeFilters).forEach(this::addFirst);
        return this;
    }

    public synchronized AttributeFilterChain addFirst(Collection<AttributeFilter> attributeFilters) {
        attributeFilters.forEach(this::addFirst);
        return this;
    }

    public synchronized AttributeFilterChain addLast(AttributeFilter attributeFilter) {
        if (this.filterDeque == null) {
            this.filterDeque = new ConcurrentLinkedDeque();
        }
        Objects.requireNonNull(this.filterDeque).addLast(attributeFilter);
        return this;
    }

    public synchronized AttributeFilterChain addLast(AttributeFilter ... attributeFilters) {
        Arrays.stream(attributeFilters).forEach(this::addLast);
        return this;
    }

    public synchronized AttributeFilterChain addLast(Collection<AttributeFilter> attributeFilters) {
        attributeFilters.forEach(this::addLast);
        return this;
    }

    public synchronized List<AttributeFilter> getFilters() {
        ConcurrentLinkedDeque<AttributeFilter> filters = this.filterDeque;
        if (filters == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AttributeFilter>(filters);
    }
}

