/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.jspecify.annotations.Nullable;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private Boolean isAbstract;
    private DataTypeDefinition dataTypeDefinition;

    public UaDataTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, boolean isAbstract) {
        super(context, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    public UaDataTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, boolean isAbstract, DataTypeDefinition dataTypeDefinition) {
        super(context, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.isAbstract = isAbstract;
        this.dataTypeDefinition = dataTypeDefinition;
    }

    public Boolean getIsAbstract() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.IsAbstract);
    }

    public DataTypeDefinition getDataTypeDefinition() {
        return (DataTypeDefinition)this.filterChain.getAttribute(this, AttributeId.DataTypeDefinition);
    }

    public void setIsAbstract(Boolean isAbstract) {
        this.filterChain.setAttribute(this, AttributeId.IsAbstract, isAbstract);
    }

    public void setDataTypeDefinition(DataTypeDefinition dataTypeDefinition) {
        this.filterChain.setAttribute(this, AttributeId.DataTypeDefinition, dataTypeDefinition);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        if (attributeId == AttributeId.IsAbstract) {
            return this.isAbstract;
        }
        if (attributeId == AttributeId.DataTypeDefinition) {
            return this.dataTypeDefinition;
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        if (attributeId == AttributeId.IsAbstract) {
            this.isAbstract = (Boolean)value;
            this.fireAttributeChanged(attributeId, value);
        } else if (attributeId == AttributeId.DataTypeDefinition) {
            this.dataTypeDefinition = (DataTypeDefinition)value;
            this.fireAttributeChanged(attributeId, value);
        } else {
            super.setAttribute(attributeId, value);
        }
    }

    public @Nullable String getNodeVersion() {
        return this.getProperty(DataTypeNodeProperties.NodeVersion).orElse(null);
    }

    public @Nullable LocalizedText[] getEnumStrings() {
        return this.getProperty(DataTypeNodeProperties.EnumStrings).orElse(null);
    }

    public @Nullable EnumValueType[] getEnumValues() {
        return this.getProperty(DataTypeNodeProperties.EnumValues).orElse(null);
    }

    public @Nullable LocalizedText[] getOptionSetValues() {
        return this.getProperty(DataTypeNodeProperties.OptionSetValues).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(DataTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public void setEnumStrings(LocalizedText[] enumStrings) {
        this.setProperty(DataTypeNodeProperties.EnumStrings, enumStrings);
    }

    public void setEnumValues(EnumValueType[] enumValues) {
        this.setProperty(DataTypeNodeProperties.EnumValues, enumValues);
    }

    public void setOptionSetValues(LocalizedText[] optionSetValues) {
        this.setProperty(DataTypeNodeProperties.OptionSetValues, optionSetValues);
    }
}

