/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.ArrayItemType;
import org.eclipse.milo.opcua.sdk.server.model.variables.DataItemTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ArrayItemTypeNode
extends DataItemTypeNode
implements ArrayItemType {
    public ArrayItemTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing, AccessLevelExType accessLevelEx) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    public ArrayItemTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions);
    }

    @Override
    public PropertyTypeNode getInstrumentRangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.INSTRUMENT_RANGE);
        return propertyNode.orElse(null);
    }

    @Override
    public Range getInstrumentRange() {
        return this.getProperty(ArrayItemType.INSTRUMENT_RANGE).orElse(null);
    }

    @Override
    public void setInstrumentRange(Range value) {
        this.setProperty(ArrayItemType.INSTRUMENT_RANGE, value);
    }

    @Override
    public PropertyTypeNode getEuRangeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.EU_RANGE);
        return propertyNode.orElse(null);
    }

    @Override
    public Range getEuRange() {
        return this.getProperty(ArrayItemType.EU_RANGE).orElse(null);
    }

    @Override
    public void setEuRange(Range value) {
        this.setProperty(ArrayItemType.EU_RANGE, value);
    }

    @Override
    public PropertyTypeNode getEngineeringUnitsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.ENGINEERING_UNITS);
        return propertyNode.orElse(null);
    }

    @Override
    public EUInformation getEngineeringUnits() {
        return this.getProperty(ArrayItemType.ENGINEERING_UNITS).orElse(null);
    }

    @Override
    public void setEngineeringUnits(EUInformation value) {
        this.setProperty(ArrayItemType.ENGINEERING_UNITS, value);
    }

    @Override
    public PropertyTypeNode getTitleNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.TITLE);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText getTitle() {
        return this.getProperty(ArrayItemType.TITLE).orElse(null);
    }

    @Override
    public void setTitle(LocalizedText value) {
        this.setProperty(ArrayItemType.TITLE, value);
    }

    @Override
    public PropertyTypeNode getAxisScaleTypeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ArrayItemType.AXIS_SCALE_TYPE);
        return propertyNode.orElse(null);
    }

    @Override
    public AxisScaleEnumeration getAxisScaleType() {
        return this.getProperty(ArrayItemType.AXIS_SCALE_TYPE).orElse(null);
    }

    @Override
    public void setAxisScaleType(AxisScaleEnumeration value) {
        this.setProperty(ArrayItemType.AXIS_SCALE_TYPE, value);
    }
}

