/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubDiagnosticsWriterGroupTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubGroupTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.WriterGroupMessageTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.WriterGroupTransportTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.WriterGroupType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class WriterGroupTypeNode
extends PubSubGroupTypeNode
implements WriterGroupType {
    public WriterGroupTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public WriterGroupTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public PropertyTypeNode getWriterGroupIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.WRITER_GROUP_ID);
        return propertyNode.orElse(null);
    }

    @Override
    public UShort getWriterGroupId() {
        return this.getProperty(WriterGroupType.WRITER_GROUP_ID).orElse(null);
    }

    @Override
    public void setWriterGroupId(UShort value) {
        this.setProperty(WriterGroupType.WRITER_GROUP_ID, value);
    }

    @Override
    public PropertyTypeNode getPublishingIntervalNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.PUBLISHING_INTERVAL);
        return propertyNode.orElse(null);
    }

    @Override
    public Double getPublishingInterval() {
        return this.getProperty(WriterGroupType.PUBLISHING_INTERVAL).orElse(null);
    }

    @Override
    public void setPublishingInterval(Double value) {
        this.setProperty(WriterGroupType.PUBLISHING_INTERVAL, value);
    }

    @Override
    public PropertyTypeNode getKeepAliveTimeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.KEEP_ALIVE_TIME);
        return propertyNode.orElse(null);
    }

    @Override
    public Double getKeepAliveTime() {
        return this.getProperty(WriterGroupType.KEEP_ALIVE_TIME).orElse(null);
    }

    @Override
    public void setKeepAliveTime(Double value) {
        this.setProperty(WriterGroupType.KEEP_ALIVE_TIME, value);
    }

    @Override
    public PropertyTypeNode getPriorityNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.PRIORITY);
        return propertyNode.orElse(null);
    }

    @Override
    public UByte getPriority() {
        return this.getProperty(WriterGroupType.PRIORITY).orElse(null);
    }

    @Override
    public void setPriority(UByte value) {
        this.setProperty(WriterGroupType.PRIORITY, value);
    }

    @Override
    public PropertyTypeNode getLocaleIdsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.LOCALE_IDS);
        return propertyNode.orElse(null);
    }

    @Override
    public String[] getLocaleIds() {
        return this.getProperty(WriterGroupType.LOCALE_IDS).orElse(null);
    }

    @Override
    public void setLocaleIds(String[] value) {
        this.setProperty(WriterGroupType.LOCALE_IDS, value);
    }

    @Override
    public PropertyTypeNode getHeaderLayoutUriNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(WriterGroupType.HEADER_LAYOUT_URI);
        return propertyNode.orElse(null);
    }

    @Override
    public String getHeaderLayoutUri() {
        return this.getProperty(WriterGroupType.HEADER_LAYOUT_URI).orElse(null);
    }

    @Override
    public void setHeaderLayoutUri(String value) {
        this.setProperty(WriterGroupType.HEADER_LAYOUT_URI, value);
    }

    @Override
    public WriterGroupTransportTypeNode getTransportSettingsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "TransportSettings");
        return component.orElse(null);
    }

    @Override
    public WriterGroupMessageTypeNode getMessageSettingsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "MessageSettings");
        return component.orElse(null);
    }

    @Override
    public PubSubDiagnosticsWriterGroupTypeNode getDiagnosticsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Diagnostics");
        return component.orElse(null);
    }

    @Override
    public UaMethodNode getAddDataSetWriterMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "AddDataSetWriter", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getRemoveDataSetWriterMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "RemoveDataSetWriter", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

