/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.PasswordOptionsMask;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.UserConfigurationMask;
import org.eclipse.milo.opcua.stack.core.types.structured.UserManagementDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface UserManagementType
extends BaseObjectType {
    public static final QualifiedProperty<UserManagementDataType[]> USERS = new QualifiedProperty("http://opcfoundation.org/UA/", "Users", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24281"), Integer.valueOf(1), UserManagementDataType[].class);
    public static final QualifiedProperty<Range> PASSWORD_LENGTH = new QualifiedProperty("http://opcfoundation.org/UA/", "PasswordLength", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=884"), Integer.valueOf(-1), Range.class);
    public static final QualifiedProperty<PasswordOptionsMask> PASSWORD_OPTIONS = new QualifiedProperty("http://opcfoundation.org/UA/", "PasswordOptions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24277"), Integer.valueOf(-1), PasswordOptionsMask.class);
    public static final QualifiedProperty<LocalizedText> PASSWORD_RESTRICTIONS = new QualifiedProperty("http://opcfoundation.org/UA/", "PasswordRestrictions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(-1), LocalizedText.class);

    public UserManagementDataType[] getUsers();

    public void setUsers(UserManagementDataType[] var1);

    public PropertyType getUsersNode();

    public Range getPasswordLength();

    public void setPasswordLength(Range var1);

    public PropertyType getPasswordLengthNode();

    public PasswordOptionsMask getPasswordOptions();

    public void setPasswordOptions(PasswordOptionsMask var1);

    public PropertyType getPasswordOptionsNode();

    public LocalizedText getPasswordRestrictions();

    public void setPasswordRestrictions(LocalizedText var1);

    public PropertyType getPasswordRestrictionsNode();

    public MethodNode getAddUserMethodNode();

    public MethodNode getModifyUserMethodNode();

    public MethodNode getRemoveUserMethodNode();

    public MethodNode getChangePasswordMethodNode();

    public static abstract class ChangePasswordMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ChangePasswordMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("OldPassword", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("NewPassword", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String oldPassword = (String)inputValues[0].getValue();
            String newPassword = (String)inputValues[1].getValue();
            this.invoke(context, oldPassword, newPassword);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, String var3) throws UaException;
    }

    public static abstract class RemoveUserMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveUserMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("UserName", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String userName = (String)inputValues[0].getValue();
            this.invoke(context, userName);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2) throws UaException;
    }

    public static abstract class ModifyUserMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ModifyUserMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("UserName", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ModifyPassword", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Password", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ModifyUserConfiguration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("UserConfiguration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24279").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ModifyDescription", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Description", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String userName = (String)inputValues[0].getValue();
            Boolean modifyPassword = (Boolean)inputValues[1].getValue();
            String password = (String)inputValues[2].getValue();
            Boolean modifyUserConfiguration = (Boolean)inputValues[3].getValue();
            UserConfigurationMask userConfiguration = (UserConfigurationMask)inputValues[4].getValue();
            Boolean modifyDescription = (Boolean)inputValues[5].getValue();
            String description = (String)inputValues[6].getValue();
            this.invoke(context, userName, modifyPassword, password, modifyUserConfiguration, userConfiguration, modifyDescription, description);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, Boolean var3, String var4, Boolean var5, UserConfigurationMask var6, Boolean var7, String var8) throws UaException;
    }

    public static abstract class AddUserMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddUserMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("UserName", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Password", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("UserConfiguration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24279").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Description", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String userName = (String)inputValues[0].getValue();
            String password = (String)inputValues[1].getValue();
            UserConfigurationMask userConfiguration = (UserConfigurationMask)inputValues[2].getValue();
            String description = (String)inputValues[3].getValue();
            this.invoke(context, userName, password, userConfiguration, description);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, String var3, UserConfigurationMask var4, String var5) throws UaException;
    }
}

