/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.FolderType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.StandaloneSubscribedDataSetDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface SubscribedDataSetFolderType
extends FolderType {
    public MethodNode getAddSubscribedDataSetMethodNode();

    public MethodNode getRemoveSubscribedDataSetMethodNode();

    public MethodNode getAddDataSetFolderMethodNode();

    public MethodNode getRemoveDataSetFolderMethodNode();

    public static abstract class RemoveDataSetFolderMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveDataSetFolderMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetFolderNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId dataSetFolderNodeId = (NodeId)inputValues[0].getValue();
            this.invoke(context, dataSetFolderNodeId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddDataSetFolderMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddDataSetFolderMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetFolderNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            Out<NodeId> dataSetFolderNodeId = new Out<NodeId>();
            this.invoke(context, name, dataSetFolderNodeId);
            return new Variant[]{new Variant((Object)dataSetFolderNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, Out<NodeId> var3) throws UaException;
    }

    public static abstract class RemoveSubscribedDataSetMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveSubscribedDataSetMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscribedDataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId subscribedDataSetNodeId = (NodeId)inputValues[0].getValue();
            this.invoke(context, subscribedDataSetNodeId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddSubscribedDataSetMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddSubscribedDataSetMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscribedDataSet", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=23600").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscribedDataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            StandaloneSubscribedDataSetDataType subscribedDataSet = (StandaloneSubscribedDataSetDataType)inputValues[0].getValue();
            Out<NodeId> subscribedDataSetNodeId = new Out<NodeId>();
            this.invoke(context, subscribedDataSet, subscribedDataSetNodeId);
            return new Variant[]{new Variant((Object)subscribedDataSetNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, StandaloneSubscribedDataSetDataType var2, Out<NodeId> var3) throws UaException;
    }
}

