/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.server.model.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.ProgramDiagnostic2TypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnostic2DataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ProgramStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    public ProgramStateMachineTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public ProgramStateMachineTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public PropertyTypeNode getCreatableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.CREATABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getCreatable() {
        return this.getProperty(ProgramStateMachineType.CREATABLE).orElse(null);
    }

    @Override
    public void setCreatable(Boolean value) {
        this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    @Override
    public PropertyTypeNode getDeletableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.DELETABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getDeletable() {
        return this.getProperty(ProgramStateMachineType.DELETABLE).orElse(null);
    }

    @Override
    public void setDeletable(Boolean value) {
        this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    @Override
    public PropertyTypeNode getAutoDeleteNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getAutoDelete() {
        return this.getProperty(ProgramStateMachineType.AUTO_DELETE).orElse(null);
    }

    @Override
    public void setAutoDelete(Boolean value) {
        this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    @Override
    public PropertyTypeNode getRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getRecycleCount() {
        return this.getProperty(ProgramStateMachineType.RECYCLE_COUNT).orElse(null);
    }

    @Override
    public void setRecycleCount(Integer value) {
        this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getInstanceCount() {
        return this.getProperty(ProgramStateMachineType.INSTANCE_COUNT).orElse(null);
    }

    @Override
    public void setInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getMaxInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxInstanceCount() {
        return this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT).orElse(null);
    }

    @Override
    public void setMaxInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getMaxRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxRecycleCount() {
        return this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT).orElse(null);
    }

    @Override
    public void setMaxRecycleCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getCurrentState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setCurrentState(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getLastTransition() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setLastTransition(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public ProgramDiagnostic2TypeNode getProgramDiagnosticNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostic");
        return component.orElse(null);
    }

    @Override
    public ProgramDiagnostic2DataType getProgramDiagnostic() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostic");
        return component.map(node -> (ProgramDiagnostic2DataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setProgramDiagnostic(ProgramDiagnostic2DataType value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostic").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseObjectTypeNode getFinalResultDataNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "FinalResultData");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Halted");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Ready");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Running");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Suspended");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getHaltedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "HaltedToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getReadyToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToHalted");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToSuspended");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToHalted");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getReadyToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToHalted");
        return component.orElse(null);
    }
}

