/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.AlarmMetricsType;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.AlarmRateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AlarmMetricsTypeNode
extends BaseObjectTypeNode
implements AlarmMetricsType {
    public AlarmMetricsTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public AlarmMetricsTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public BaseDataVariableTypeNode getAlarmCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "AlarmCount");
        return component.orElse(null);
    }

    @Override
    public UInteger getAlarmCount() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "AlarmCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setAlarmCount(UInteger value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "AlarmCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getStartTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime");
        return component.orElse(null);
    }

    @Override
    public DateTime getStartTime() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setStartTime(DateTime value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumActiveStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumActiveState");
        return component.orElse(null);
    }

    @Override
    public Double getMaximumActiveState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumActiveState");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setMaximumActiveState(Double value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumActiveState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumUnAckNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumUnAck");
        return component.orElse(null);
    }

    @Override
    public Double getMaximumUnAck() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumUnAck");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setMaximumUnAck(Double value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumUnAck").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public AlarmRateVariableTypeNode getCurrentAlarmRateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentAlarmRate");
        return component.orElse(null);
    }

    @Override
    public Double getCurrentAlarmRate() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentAlarmRate");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setCurrentAlarmRate(Double value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentAlarmRate").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public AlarmRateVariableTypeNode getMaximumAlarmRateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumAlarmRate");
        return component.orElse(null);
    }

    @Override
    public Double getMaximumAlarmRate() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumAlarmRate");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setMaximumAlarmRate(Double value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumAlarmRate").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumReAlarmCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumReAlarmCount");
        return component.orElse(null);
    }

    @Override
    public UInteger getMaximumReAlarmCount() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumReAlarmCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setMaximumReAlarmCount(UInteger value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "MaximumReAlarmCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public AlarmRateVariableTypeNode getAverageAlarmRateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "AverageAlarmRate");
        return component.orElse(null);
    }

    @Override
    public Double getAverageAlarmRate() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "AverageAlarmRate");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setAverageAlarmRate(Double value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "AverageAlarmRate").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UaMethodNode getResetMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Reset", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

