/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.security.cert.X509Certificate;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.jspecify.annotations.Nullable;

public interface Identity {
    public UserTokenType getUserTokenType();

    public @Nullable Object getUserData();

    public void setUserData(@Nullable Object var1);

    public boolean equalTo(Identity var1);

    public static interface IssuedIdentity
    extends Identity {
        public ByteString getTokenData();
    }

    public static interface X509UserIdentity
    extends Identity {
        public X509Certificate getCertificate();
    }

    public static interface UsernameIdentity
    extends Identity {
        public String getUsername();
    }

    public static interface AnonymousIdentity
    extends Identity {
        @Override
        default public boolean equalTo(Identity identity) {
            return identity instanceof AnonymousIdentity;
        }
    }
}

