/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.Identity;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeValidator
implements IdentityValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<IdentityValidator> validators;

    public CompositeValidator(IdentityValidator ... validators) {
        this(List.of(validators));
    }

    public CompositeValidator(List<IdentityValidator> validators) {
        this.validators = List.copyOf(validators);
    }

    @Override
    public Identity validateIdentityToken(Session session, UserIdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        Iterator iterator = this.validators.stream().filter(v -> v.getSupportedTokenTypes().contains(policy.getTokenType())).iterator();
        while (iterator.hasNext()) {
            IdentityValidator validator = (IdentityValidator)iterator.next();
            try {
                return validator.validateIdentityToken(session, token, policy, signature);
            }
            catch (Exception e) {
                if (!iterator.hasNext()) {
                    throw e;
                }
                this.logger.debug("IdentityValidator={} failed, trying next...", (Object)validator.toString());
            }
        }
        throw new UaException(0x80200000L);
    }

    @Override
    public Set<UserTokenType> getSupportedTokenTypes() {
        return this.validators.stream().flatMap(v -> v.getSupportedTokenTypes().stream()).collect(Collectors.toSet());
    }
}

