/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import java.lang.reflect.Array;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.conversions.ImplicitConversions;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

abstract class ImplicitConversionBinaryOperator<T>
implements Operator<T> {
    ImplicitConversionBinaryOperator() {
    }

    @Override
    public void validate(FilterContext context, FilterOperand[] operands) throws ValidationException {
        if (operands.length < 2) {
            throw new ValidationException(2160263168L);
        }
    }

    @Override
    public @Nullable T apply(OperatorContext context, BaseEventTypeNode eventNode, FilterOperand[] operands) throws UaException {
        int p1;
        this.validate(context, operands);
        FilterOperand op0 = operands[0];
        FilterOperand op1 = operands[1];
        Object value0 = context.resolve(op0, eventNode);
        Object value1 = context.resolve(op1, eventNode);
        if (value0 == null || value1 == null) {
            return null;
        }
        OpcUaDataType dt0 = ImplicitConversionBinaryOperator.getType(value0);
        OpcUaDataType dt1 = ImplicitConversionBinaryOperator.getType(value1);
        if (dt0 == null || dt1 == null) {
            throw new UaException(0x80010000L);
        }
        int p0 = ImplicitConversions.getPrecedence(dt0);
        if (p0 == (p1 = ImplicitConversions.getPrecedence(dt1))) {
            assert (dt0 == dt1);
            return this.apply(context, eventNode, dt0, value0, value1);
        }
        if (p0 >= p1) {
            Object converted1 = ImplicitConversionBinaryOperator.convert(value1, dt0);
            return this.apply(context, eventNode, dt0, value0, converted1);
        }
        Object converted0 = ImplicitConversionBinaryOperator.convert(value0, dt1);
        return this.apply(context, eventNode, dt1, converted0, value1);
    }

    protected abstract @Nullable T apply(OperatorContext var1, BaseEventTypeNode var2, OpcUaDataType var3, @Nullable Object var4, @Nullable Object var5) throws UaException;

    private static @Nullable Object convert(@NonNull Object value, OpcUaDataType targetType) {
        if (value.getClass().isArray()) {
            return ImplicitConversionBinaryOperator.convertArray(value, targetType);
        }
        return ImplicitConversions.convert(value, targetType);
    }

    private static Object convertArray(@NonNull Object array, OpcUaDataType targetType) {
        int[] dimensions = ArrayUtil.getDimensions((Object)array);
        Object flattened = ArrayUtil.flatten((Object)array);
        int length = Array.getLength(flattened);
        Object transformed = Array.newInstance(targetType.getBackingClass(), length);
        for (int i = 0; i < length; ++i) {
            Object sourceValue = Array.get(flattened, i);
            Object targetValue = ImplicitConversions.convert(sourceValue, targetType);
            Array.set(transformed, i, targetValue);
        }
        return ArrayUtil.unflatten((Object)transformed, (int[])dimensions);
    }

    private static OpcUaDataType getType(@NonNull Object o) {
        if (o.getClass().isArray()) {
            return OpcUaDataType.fromBackingClass((Class)ArrayUtil.getType((Object)o));
        }
        return OpcUaDataType.fromBackingClass(o.getClass());
    }
}

