/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class UInt32Conversions {
    private UInt32Conversions() {
    }

    static @NonNull Boolean uInt32ToBoolean(@NonNull UInteger ui) {
        return ui.intValue() != 0;
    }

    static @Nullable UByte uInt32ToByte(@NonNull UInteger ui) {
        long l = ui.longValue();
        if (l <= 255L) {
            return Unsigned.ubyte((long)l);
        }
        return null;
    }

    static @NonNull Double uInt32ToDouble(@NonNull UInteger ui) {
        return ui.doubleValue();
    }

    static @NonNull Float uInt32ToFloat(@NonNull UInteger ui) {
        return Float.valueOf(ui.floatValue());
    }

    static @Nullable Short uInt32ToInt16(@NonNull UInteger ui) {
        int i = ui.intValue();
        if (i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return null;
    }

    static @Nullable Integer uInt32ToInt32(@NonNull UInteger ui) {
        long l = ui.longValue();
        if (l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return null;
    }

    static @NonNull Long uInt32ToInt64(@NonNull UInteger ui) {
        return ui.longValue();
    }

    static @Nullable Byte uInt32ToSByte(@NonNull UInteger ui) {
        int i = ui.intValue();
        if (i <= 127) {
            return (byte)i;
        }
        return null;
    }

    static @NonNull StatusCode uInt32ToStatusCode(@NonNull UInteger ui) {
        return new StatusCode(ui);
    }

    static @NonNull String uInt32ToString(@NonNull UInteger ui) {
        return ui.toString();
    }

    static @Nullable UShort uInt32ToUInt16(@NonNull UInteger ui) {
        int i = ui.intValue();
        if (i <= 65535) {
            return Unsigned.ushort((int)i);
        }
        return null;
    }

    static @NonNull ULong uInt32ToUInt64(@NonNull UInteger ui) {
        return Unsigned.ulong((long)ui.longValue());
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof UInteger) {
            UInteger ui = (UInteger)o;
            return implicit ? UInt32Conversions.implicitConversion(ui, targetType) : UInt32Conversions.explicitConversion(ui, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull UInteger ui, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt32Conversions.uInt32ToBoolean(ui);
            }
            case Byte: {
                return UInt32Conversions.uInt32ToByte(ui);
            }
            case Int16: {
                return UInt32Conversions.uInt32ToInt16(ui);
            }
            case SByte: {
                return UInt32Conversions.uInt32ToSByte(ui);
            }
            case StatusCode: {
                return UInt32Conversions.uInt32ToStatusCode(ui);
            }
            case String: {
                return UInt32Conversions.uInt32ToString(ui);
            }
            case UInt16: {
                return UInt32Conversions.uInt32ToUInt16(ui);
            }
        }
        return UInt32Conversions.implicitConversion(ui, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull UInteger ui, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt32Conversions.uInt32ToDouble(ui);
            }
            case Float: {
                return UInt32Conversions.uInt32ToFloat(ui);
            }
            case Int32: {
                return UInt32Conversions.uInt32ToInt32(ui);
            }
            case Int64: {
                return UInt32Conversions.uInt32ToInt64(ui);
            }
            case UInt64: {
                return UInt32Conversions.uInt32ToUInt64(ui);
            }
        }
        return null;
    }
}

