/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class UInt16Conversions {
    private UInt16Conversions() {
    }

    static @NonNull Boolean uInt16ToBoolean(@NonNull UShort us) {
        return us.intValue() != 0;
    }

    static @Nullable UByte uInt16ToByte(@NonNull UShort us) {
        int i = us.intValue();
        if (i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    static @NonNull Double uInt16ToDouble(@NonNull UShort us) {
        return us.doubleValue();
    }

    static @NonNull Float uInt16ToFloat(@NonNull UShort us) {
        return Float.valueOf(us.floatValue());
    }

    static @Nullable Short uInt16ToInt16(@NonNull UShort us) {
        int i = us.intValue();
        if (i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return null;
    }

    static @NonNull Integer uInt16ToInt32(@NonNull UShort us) {
        return us.intValue();
    }

    static @NonNull Long uInt16ToInt64(@NonNull UShort us) {
        return us.longValue();
    }

    static @Nullable Byte uInt16ToSByte(@NonNull UShort us) {
        int i = us.intValue();
        if (i <= 127) {
            return (byte)i;
        }
        return null;
    }

    static @NonNull StatusCode uInt16ToStatusCode(@NonNull UShort us) {
        return new StatusCode(us.longValue() << 16);
    }

    static @NonNull String uInt16ToString(@NonNull UShort us) {
        return us.toString();
    }

    static @NonNull UInteger uInt16ToUInt32(@NonNull UShort us) {
        return Unsigned.uint((int)us.intValue());
    }

    static @NonNull ULong uInt16ToUInt64(@NonNull UShort us) {
        return Unsigned.ulong((long)us.longValue());
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof UShort) {
            UShort us = (UShort)o;
            return implicit ? UInt16Conversions.implicitConversion(us, targetType) : UInt16Conversions.explicitConversion(us, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull UShort us, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt16Conversions.uInt16ToBoolean(us);
            }
            case Byte: {
                return UInt16Conversions.uInt16ToByte(us);
            }
            case SByte: {
                return UInt16Conversions.uInt16ToSByte(us);
            }
            case String: {
                return UInt16Conversions.uInt16ToString(us);
            }
        }
        return UInt16Conversions.implicitConversion(us, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull UShort us, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt16Conversions.uInt16ToDouble(us);
            }
            case Float: {
                return UInt16Conversions.uInt16ToFloat(us);
            }
            case Int16: {
                return UInt16Conversions.uInt16ToInt16(us);
            }
            case Int32: {
                return UInt16Conversions.uInt16ToInt32(us);
            }
            case Int64: {
                return UInt16Conversions.uInt16ToInt64(us);
            }
            case StatusCode: {
                return UInt16Conversions.uInt16ToStatusCode(us);
            }
            case UInt32: {
                return UInt16Conversions.uInt16ToUInt32(us);
            }
            case UInt64: {
                return UInt16Conversions.uInt16ToUInt64(us);
            }
        }
        return null;
    }
}

