/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class NodeIdConversions {
    private NodeIdConversions() {
    }

    static @NonNull ExpandedNodeId nodeIdToExpandedNodeId(@NonNull NodeId nodeId) {
        return nodeId.expanded();
    }

    static @NonNull String nodeIdToString(@NonNull NodeId nodeId) {
        return nodeId.toParseableString();
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof NodeId) {
            NodeId nodeId = (NodeId)o;
            return implicit ? NodeIdConversions.implicitConversion(nodeId, targetType) : NodeIdConversions.explicitConversion(nodeId, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull NodeId nodeId, OpcUaDataType targetType) {
        return NodeIdConversions.implicitConversion(nodeId, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull NodeId nodeId, OpcUaDataType targetType) {
        switch (targetType) {
            case ExpandedNodeId: {
                return NodeIdConversions.nodeIdToExpandedNodeId(nodeId);
            }
            case String: {
                return NodeIdConversions.nodeIdToString(nodeId);
            }
        }
        return null;
    }
}

