/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ByteConversions {
    private ByteConversions() {
    }

    static @NonNull Boolean byteToBoolean(@NonNull UByte ub) {
        return ub.intValue() != 0;
    }

    static @NonNull Double byteToDouble(@NonNull UByte ub) {
        return ub.doubleValue();
    }

    static @NonNull Float byteToFloat(@NonNull UByte ub) {
        return Float.valueOf(ub.floatValue());
    }

    static @NonNull Short byteToInt16(@NonNull UByte ub) {
        return ub.shortValue();
    }

    static @NonNull Integer byteToInt32(@NonNull UByte ub) {
        return ub.intValue();
    }

    static @NonNull Long byteToInt64(@NonNull UByte ub) {
        return ub.longValue();
    }

    static @Nullable Byte byteToSByte(@NonNull UByte ub) {
        return ub.intValue() > 127 ? null : Byte.valueOf(ub.byteValue());
    }

    static @NonNull String byteToString(@NonNull UByte ub) {
        return ub.toString();
    }

    static @NonNull UShort byteToUInt16(@NonNull UByte ub) {
        return Unsigned.ushort((int)ub.intValue());
    }

    static @NonNull UInteger byteToUInt32(@NonNull UByte ub) {
        return Unsigned.uint((int)ub.intValue());
    }

    static @NonNull ULong byteToUInt64(@NonNull UByte ub) {
        return Unsigned.ulong((long)ub.longValue());
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof UByte) {
            UByte b = (UByte)o;
            return implicit ? ByteConversions.implicitConversion(b, targetType) : ByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull UByte b, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return ByteConversions.byteToBoolean(b);
            }
            case String: {
                return ByteConversions.byteToString(b);
            }
        }
        return ByteConversions.implicitConversion(b, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull UByte b, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return ByteConversions.byteToDouble(b);
            }
            case Float: {
                return ByteConversions.byteToFloat(b);
            }
            case Int16: {
                return ByteConversions.byteToInt16(b);
            }
            case Int32: {
                return ByteConversions.byteToInt32(b);
            }
            case Int64: {
                return ByteConversions.byteToInt64(b);
            }
            case SByte: {
                return ByteConversions.byteToSByte(b);
            }
            case UInt16: {
                return ByteConversions.byteToUInt16(b);
            }
            case UInt32: {
                return ByteConversions.byteToUInt32(b);
            }
            case UInt64: {
                return ByteConversions.byteToUInt64(b);
            }
        }
        return null;
    }
}

