/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

class Util {
    private Util() {
    }

    static String buildBrowseNamePath(UaNode node) {
        return Util.buildBrowseNamePath(node, new ArrayList<String>());
    }

    private static String buildBrowseNamePath(UaNode node, List<String> browseNames) {
        if (node == null || node.getNodeId().equals((Object)NodeIds.ObjectsFolder)) {
            Collections.reverse(browseNames);
            return String.join((CharSequence)".", browseNames);
        }
        ReferenceTypeTree referenceTypeTree = node.getNodeContext().getServer().getReferenceTypeTree();
        browseNames.add(node.getBrowseName().toParseableString());
        Optional<Reference> referenceToParent = node.getReferences().stream().filter(r -> r.isInverse() && referenceTypeTree.isSubtypeOf(r.getReferenceTypeId(), NodeIds.HierarchicalReferences)).findFirst();
        Optional parentNode = referenceToParent.flatMap(r -> node.getNodeContext().getServer().getAddressSpaceManager().getManagedNode(r.getTargetNodeId()));
        return Util.buildBrowseNamePath(parentNode.orElse(null), browseNames);
    }

    static AttributeFilter diagnosticValueFilter(AtomicBoolean diagnosticsEnabled, Function<AttributeFilterContext, DataValue> get) {
        return AttributeFilters.getValue(ctx -> {
            if (diagnosticsEnabled.get()) {
                return (DataValue)get.apply((AttributeFilterContext)ctx);
            }
            return new DataValue(Variant.NULL_VALUE, new StatusCode(2151284736L), DateTime.now());
        });
    }
}

