/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.objects;

import java.util.List;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.NodeManager;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionDiagnosticsVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionSecurityDiagnosticsVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SubscriptionDiagnosticsVariableArray;
import org.eclipse.milo.opcua.sdk.server.model.objects.SessionDiagnosticsObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;

public class SessionDiagnosticsObject
extends AbstractLifecycle {
    private SessionDiagnosticsVariable sessionDiagnosticsVariable;
    private SessionSecurityDiagnosticsVariable sessionSecurityDiagnosticsVariable;
    private SubscriptionDiagnosticsVariableArray subscriptionDiagnosticsVariableArray;
    private final SessionDiagnosticsObjectTypeNode node;
    private final Session session;
    private final NodeManager<UaNode> diagnosticsNodeManager;

    public SessionDiagnosticsObject(SessionDiagnosticsObjectTypeNode node, Session session, NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.session = session;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
    }

    @Override
    protected void onStartup() {
        this.sessionDiagnosticsVariable = new SessionDiagnosticsVariable(this.node.getSessionDiagnosticsNode(), this.session);
        this.sessionDiagnosticsVariable.startup();
        this.sessionSecurityDiagnosticsVariable = new SessionSecurityDiagnosticsVariable(this.node.getSessionSecurityDiagnosticsNode(), this.session);
        this.sessionSecurityDiagnosticsVariable.startup();
        this.subscriptionDiagnosticsVariableArray = new SubscriptionDiagnosticsVariableArray(this.node.getSubscriptionDiagnosticsArrayNode(), this.diagnosticsNodeManager){

            @Override
            protected List<Subscription> getSubscriptions() {
                return SessionDiagnosticsObject.this.session.getSubscriptionManager().getSubscriptions();
            }
        };
        this.subscriptionDiagnosticsVariableArray.startup();
    }

    @Override
    protected void onShutdown() {
        this.sessionDiagnosticsVariable.shutdown();
        this.sessionSecurityDiagnosticsVariable.shutdown();
        this.subscriptionDiagnosticsVariableArray.shutdown();
        this.node.delete();
    }
}

