/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.LifecycleManager;
import org.eclipse.milo.opcua.sdk.server.ManagedAddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;

public abstract class ManagedAddressSpaceWithLifecycle
extends ManagedAddressSpace
implements Lifecycle {
    private final LifecycleManager lifecycleManager = new LifecycleManager();

    public ManagedAddressSpaceWithLifecycle(OpcUaServer server) {
        super(server);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ManagedAddressSpaceWithLifecycle.this.registerNodeManager(ManagedAddressSpaceWithLifecycle.this.getNodeManager());
            }

            @Override
            public void shutdown() {
                ManagedAddressSpaceWithLifecycle.this.unregisterNodeManager(ManagedAddressSpaceWithLifecycle.this.getNodeManager());
            }
        });
    }

    public ManagedAddressSpaceWithLifecycle(OpcUaServer server, UaNodeManager nodeManager) {
        super(server, nodeManager);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ManagedAddressSpaceWithLifecycle.this.registerNodeManager(ManagedAddressSpaceWithLifecycle.this.getNodeManager());
            }

            @Override
            public void shutdown() {
                ManagedAddressSpaceWithLifecycle.this.unregisterNodeManager(ManagedAddressSpaceWithLifecycle.this.getNodeManager());
            }
        });
    }

    @Override
    public final void startup() {
        this.lifecycleManager.startup();
    }

    @Override
    public final void shutdown() {
        this.lifecycleManager.shutdown();
    }

    protected LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    protected void registerNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().register(nodeManager);
    }

    protected void unregisterNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().unregister(nodeManager);
    }
}

