/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OperationLimits;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientBrowseUtils;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientVariableType;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableType;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableTypeTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableTypeTreeBuilder.class);

    public static VariableTypeTree build(OpcUaClient client) throws UaException {
        Tree root = new Tree(null, (Object)new ClientVariableType(QualifiedName.parse((String)"0:BaseVariableType"), NodeIds.BaseVariableType, new DataValue(Variant.NULL_VALUE), NodeIds.BaseDataType, -1, null, true));
        NamespaceTable namespaceTable = client.readNamespaceTable();
        OperationLimits operationLimits = client.getOperationLimits();
        VariableTypeTreeBuilder.addChildren(List.of(root), client, namespaceTable, operationLimits);
        return new VariableTypeTree(root);
    }

    public static CompletableFuture<VariableTypeTree> buildAsync(OpcUaClient client) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return VariableTypeTreeBuilder.build(client);
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, client.getTransport().getConfig().getExecutor());
    }

    private static void addChildren(List<Tree<VariableType>> parentTypes, OpcUaClient client, NamespaceTable namespaceTable, OperationLimits operationLimits) {
        List<List<ReferenceDescription>> parentSubtypes = ClientBrowseUtils.browseWithOperationLimits(client, parentTypes.stream().map(tree -> new BrowseDescription(((VariableType)tree.getValue()).getNodeId(), BrowseDirection.Forward, NodeIds.HasSubtype, Boolean.valueOf(true), Unsigned.uint((int)NodeClass.VariableType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).collect(Collectors.toList()), operationLimits);
        ArrayList<Tree<VariableType>> childTypes = new ArrayList<Tree<VariableType>>();
        for (int i = 0; i < parentTypes.size(); ++i) {
            Tree<VariableType> tree2 = parentTypes.get(i);
            List<ReferenceDescription> subtypes = parentSubtypes.get(i);
            List<NodeId> variableTypeIds = subtypes.stream().map(reference -> reference.getNodeId().toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)).collect(Collectors.toList());
            List<Attributes> variableTypeAttributes = VariableTypeTreeBuilder.readVariableTypeAttributes(client, variableTypeIds, operationLimits);
            assert (subtypes.size() == variableTypeIds.size() && subtypes.size() == variableTypeAttributes.size());
            ArrayList<ClientVariableType> variableTypes = new ArrayList<ClientVariableType>();
            for (int j = 0; j < subtypes.size(); ++j) {
                QualifiedName browseName = subtypes.get(j).getBrowseName();
                NodeId variableTypeId = variableTypeIds.get(j);
                Attributes attributes = variableTypeAttributes.get(j);
                ClientVariableType variableType = new ClientVariableType(browseName, variableTypeId, attributes.value, attributes.dataType, attributes.valueRank, attributes.arrayDimensions, attributes.isAbstract);
                variableTypes.add(variableType);
                LOGGER.debug("Added VariableType: {}", (Object)variableType.getBrowseName().toParseableString());
            }
            for (ClientVariableType variableType : variableTypes) {
                Tree childNode = tree2.addChild((Object)variableType);
                childTypes.add((Tree<VariableType>)childNode);
            }
        }
        if (!childTypes.isEmpty()) {
            VariableTypeTreeBuilder.addChildren(childTypes, client, namespaceTable, operationLimits);
        }
    }

    private static List<Attributes> readVariableTypeAttributes(OpcUaClient client, List<NodeId> variableTypeIds, OperationLimits operationLimits) {
        if (variableTypeIds.isEmpty()) {
            return List.of();
        }
        ArrayList<ReadValueId> readValueIds = new ArrayList<ReadValueId>();
        for (NodeId variableTypeId : variableTypeIds) {
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.IsAbstract.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.DataType.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.ValueRank.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.ArrayDimensions.uid(), null, QualifiedName.NULL_VALUE));
        }
        ArrayList<Attributes> attributes = new ArrayList<Attributes>();
        List<DataValue> values = ClientBrowseUtils.readWithOperationLimits(client, readValueIds, operationLimits);
        for (int i = 0; i < values.size(); i += 5) {
            DataValue isAbstractValue = values.get(i);
            DataValue valueValue = values.get(i + 1);
            DataValue dataTypeValue = values.get(i + 2);
            DataValue valueRankValue = values.get(i + 3);
            DataValue arrayDimensionsValue = values.get(i + 4);
            Boolean isAbstract = false;
            DataValue value = new DataValue(Variant.NULL_VALUE);
            NodeId dataType = NodeIds.BaseDataType;
            Integer valueRank = -1;
            UInteger[] arrayDimensions = null;
            if (isAbstractValue.statusCode().isGood()) {
                isAbstract = (Boolean)isAbstractValue.value().value();
            }
            if (valueValue.statusCode().isGood()) {
                value = valueValue;
            }
            if (dataTypeValue.statusCode().isGood()) {
                dataType = (NodeId)dataTypeValue.value().value();
            }
            if (valueRankValue.statusCode().isGood()) {
                valueRank = (Integer)valueRankValue.value().value();
            }
            if (arrayDimensionsValue.statusCode().isGood()) {
                arrayDimensions = (UInteger[])arrayDimensionsValue.value().value();
            }
            attributes.add(new Attributes(isAbstract, value, dataType, valueRank, arrayDimensions));
        }
        return attributes;
    }

    private record Attributes(Boolean isAbstract, DataValue value, NodeId dataType, Integer valueRank, @Nullable UInteger[] arrayDimensions) {
    }
}

