/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OperationLimits;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientBrowseUtils;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientDataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyClientDataTypeTree
extends DataTypeTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyClientDataTypeTree.class);
    private final OpcUaClient client;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<NodeId> attemptedResolution = ConcurrentHashMap.newKeySet();
    private volatile NamespaceTable namespaceTable;

    public LazyClientDataTypeTree(OpcUaClient client) {
        this(client, LazyClientDataTypeTree.createRootTree());
    }

    public LazyClientDataTypeTree(OpcUaClient client, Tree<DataType> preSeededTree) {
        super(preSeededTree);
        this.client = client;
    }

    private static Tree<DataType> createRootTree() {
        return new Tree(null, (Object)new ClientDataType(QualifiedName.parse((String)"0:BaseDataType"), NodeIds.BaseDataType, null, null, null, null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamespaceTable getNamespaceTable() throws UaException {
        NamespaceTable ns = this.namespaceTable;
        if (ns == null) {
            LazyClientDataTypeTree lazyClientDataTypeTree = this;
            synchronized (lazyClientDataTypeTree) {
                ns = this.namespaceTable;
                if (ns == null) {
                    this.namespaceTable = ns = this.client.readNamespaceTable();
                }
            }
        }
        return ns;
    }

    public void invalidateNamespaceTable() {
        this.namespaceTable = null;
    }

    public void refreshNamespaceTable() throws UaException {
        this.namespaceTable = this.client.readNamespaceTable();
    }

    public boolean isResolved(NodeId typeId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.types.containsKey(typeId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearFailedResolutions() {
        this.lock.writeLock().lock();
        try {
            this.attemptedResolution.retainAll(this.types.keySet());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void ensureResolved(NodeId dataTypeId) {
        this.lock.readLock().lock();
        try {
            if (this.types.containsKey(dataTypeId) || this.attemptedResolution.contains(dataTypeId)) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.types.containsKey(dataTypeId) || this.attemptedResolution.contains(dataTypeId)) {
                return;
            }
            this.attemptedResolution.add(dataTypeId);
            try {
                this.resolvePath(dataTypeId);
            }
            catch (UaException e) {
                LOGGER.debug("Failed to resolve DataType {}: {}", (Object)dataTypeId, (Object)e.getMessage());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void resolvePath(NodeId dataTypeId) throws UaException {
        NamespaceTable nsTable = this.getNamespaceTable();
        OperationLimits limits = this.client.getOperationLimits();
        List<NodeId> pathToResolve = this.browseInverseUntilKnown(dataTypeId, this.types.keySet(), nsTable);
        if (pathToResolve.isEmpty() || pathToResolve.size() < 2) {
            LOGGER.debug("Could not resolve path to known ancestor for DataType {}", (Object)dataTypeId);
            return;
        }
        List<NodeId> nodesToAdd = pathToResolve.subList(0, pathToResolve.size() - 1);
        NodeId knownAncestorId = pathToResolve.get(pathToResolve.size() - 1);
        List<ClientDataType> dataTypes = this.fetchDataTypeInfoBatch(nodesToAdd, nsTable, limits);
        Tree parentTree = (Tree)this.types.get(knownAncestorId);
        for (int i = nodesToAdd.size() - 1; i >= 0; --i) {
            ClientDataType dataType = dataTypes.get(i);
            if (dataType == null || parentTree == null) continue;
            Tree childTree = parentTree.addChild((Object)dataType);
            this.types.put(dataType.getNodeId(), childTree);
            parentTree = childTree;
            LOGGER.debug("Resolved DataType: {}", (Object)dataType.getBrowseName().toParseableString());
        }
    }

    private List<ClientDataType> fetchDataTypeInfoBatch(List<NodeId> nodeIds, NamespaceTable nsTable, OperationLimits limits) {
        ArrayList<ReadValueId> readValueIds = new ArrayList<ReadValueId>();
        for (NodeId nodeId : nodeIds) {
            readValueIds.add(new ReadValueId(nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.IsAbstract.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.DataTypeDefinition.uid(), null, QualifiedName.NULL_VALUE));
        }
        List<DataValue> values = ClientBrowseUtils.readWithOperationLimits(this.client, readValueIds, limits);
        List<List<ReferenceDescription>> encodingRefs = this.browseEncodings(nodeIds, limits);
        ArrayList<ClientDataType> result = new ArrayList<ClientDataType>();
        for (int i = 0; i < nodeIds.size(); ++i) {
            NodeId nodeId = nodeIds.get(i);
            int valueOffset = i * 3;
            QualifiedName browseName = LazyClientDataTypeTree.extractBrowseName(values.get(valueOffset));
            Boolean isAbstract = LazyClientDataTypeTree.extractIsAbstract(values.get(valueOffset + 1));
            DataTypeDefinition definition = this.extractDataTypeDefinition(values.get(valueOffset + 2));
            NodeId binaryEncodingId = null;
            NodeId xmlEncodingId = null;
            NodeId jsonEncodingId = null;
            for (ReferenceDescription r : encodingRefs.get(i)) {
                if (r.getBrowseName().equals((Object)DataTypeEncoding.BINARY_ENCODING_NAME) || Objects.equals(r.getBrowseName().name(), "Default Binary")) {
                    binaryEncodingId = r.getNodeId().toNodeId(nsTable).orElse(null);
                    continue;
                }
                if (r.getBrowseName().equals((Object)DataTypeEncoding.XML_ENCODING_NAME) || Objects.equals(r.getBrowseName().name(), "Default XML")) {
                    xmlEncodingId = r.getNodeId().toNodeId(nsTable).orElse(null);
                    continue;
                }
                if (!r.getBrowseName().equals((Object)DataTypeEncoding.JSON_ENCODING_NAME) && !Objects.equals(r.getBrowseName().name(), "Default JSON")) continue;
                jsonEncodingId = r.getNodeId().toNodeId(nsTable).orElse(null);
            }
            result.add(new ClientDataType(browseName, nodeId, binaryEncodingId, xmlEncodingId, jsonEncodingId, definition, isAbstract));
        }
        return result;
    }

    private List<NodeId> browseInverseUntilKnown(NodeId startId, Set<NodeId> knownTypeIds, NamespaceTable namespaceTable) {
        ArrayList<NodeId> path = new ArrayList<NodeId>();
        NodeId current = startId;
        while (current != null && !knownTypeIds.contains(current)) {
            path.add(current);
            current = this.browseInverseParent(current, namespaceTable);
        }
        if (current != null && knownTypeIds.contains(current)) {
            path.add(current);
            return path;
        }
        return List.of();
    }

    private @Nullable NodeId browseInverseParent(NodeId nodeId, NamespaceTable namespaceTable) {
        try {
            BrowseDescription bd = new BrowseDescription(nodeId, BrowseDirection.Inverse, NodeIds.HasSubtype, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.DataType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()));
            BrowseResult result = this.client.browse(bd);
            if (result.getStatusCode().isGood() && result.getReferences() != null && result.getReferences().length > 0) {
                return result.getReferences()[0].getNodeId().toNodeId(namespaceTable).orElse(null);
            }
        }
        catch (UaException e) {
            LOGGER.debug("Failed to browse inverse parent for {}: {}", (Object)nodeId, (Object)e.getMessage());
        }
        return null;
    }

    private List<List<ReferenceDescription>> browseEncodings(List<NodeId> dataTypeIds, OperationLimits limits) {
        List<BrowseDescription> browseDescriptions = dataTypeIds.stream().map(dataTypeId -> new BrowseDescription(dataTypeId, BrowseDirection.Forward, NodeIds.HasEncoding, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Object.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).toList();
        return ClientBrowseUtils.browseWithOperationLimits(this.client, browseDescriptions, limits);
    }

    private static QualifiedName extractBrowseName(DataValue value) {
        Object object;
        if (value.statusCode().isGood() && (object = value.value().value()) instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)object;
            return qn;
        }
        return QualifiedName.NULL_VALUE;
    }

    private static Boolean extractIsAbstract(DataValue value) {
        Object object;
        if (value.statusCode().isGood() && (object = value.value().value()) instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        return false;
    }

    private @Nullable DataTypeDefinition extractDataTypeDefinition(DataValue value) {
        if (value.statusCode().isGood()) {
            Object o = value.value().value();
            if (o instanceof ExtensionObject) {
                ExtensionObject xo = (ExtensionObject)o;
                try {
                    UaStructuredType decoded = xo.decode(this.client.getStaticEncodingContext());
                    if (decoded instanceof DataTypeDefinition) {
                        DataTypeDefinition dtd = (DataTypeDefinition)decoded;
                        return dtd;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error decoding DataTypeDefinition: {}", (Object)e.getMessage());
                }
            } else if (o instanceof DataTypeDefinition) {
                DataTypeDefinition dtd = (DataTypeDefinition)o;
                return dtd;
            }
        }
        return null;
    }

    public Tree<DataType> getRoot() {
        this.lock.readLock().lock();
        try {
            Tree tree = this.tree.map(dataType -> dataType);
            return tree;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsType(NodeId typeId) {
        this.ensureResolved(typeId);
        this.lock.readLock().lock();
        try {
            boolean bl = super.containsType(typeId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable DataType getType(NodeId nodeId) {
        this.ensureResolved(nodeId);
        this.lock.readLock().lock();
        try {
            DataType dataType = (DataType)super.getType(nodeId);
            return dataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Class<?> getBackingClass(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            Class clazz = super.getBackingClass(dataTypeId);
            return clazz;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OpcUaDataType getBuiltinType(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            OpcUaDataType opcUaDataType = super.getBuiltinType(dataTypeId);
            return opcUaDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable DataType getDataType(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            DataType dataType = super.getDataType(dataTypeId);
            return dataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable NodeId getBinaryEncodingId(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            NodeId nodeId = super.getBinaryEncodingId(dataTypeId);
            return nodeId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable NodeId getXmlEncodingId(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            NodeId nodeId = super.getXmlEncodingId(dataTypeId);
            return nodeId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable NodeId getJsonEncodingId(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            NodeId nodeId = super.getJsonEncodingId(dataTypeId);
            return nodeId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable DataTypeDefinition getDataTypeDefinition(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            DataTypeDefinition dataTypeDefinition = super.getDataTypeDefinition(dataTypeId);
            return dataTypeDefinition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssignable(NodeId dataTypeId, Class<?> clazz) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            boolean bl = super.isAssignable(dataTypeId, clazz);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEnumType(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            boolean bl = super.isEnumType(dataTypeId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isStructType(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            boolean bl = super.isStructType(dataTypeId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public @Nullable Tree<DataType> getTreeNode(NodeId dataTypeId) {
        this.ensureResolved(dataTypeId);
        this.lock.readLock().lock();
        try {
            Tree tree = super.getTreeNode(dataTypeId);
            return tree;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubtypeOf(NodeId typeId, NodeId superTypeId) {
        this.ensureResolved(typeId);
        this.lock.readLock().lock();
        try {
            boolean bl = super.isSubtypeOf(typeId, superTypeId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

