/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.core.types.codec.DynamicCodecFactory;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeInitializer;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyClientDataTypeManager
extends DefaultDataTypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyClientDataTypeManager.class);
    private final OpcUaClient client;
    private final DataTypeTree dataTypeTree;
    private final BiFunction<DataType, DataTypeTree, DataTypeCodec> codecFactory;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<NodeId> attemptedResolution = ConcurrentHashMap.newKeySet();

    public LazyClientDataTypeManager(OpcUaClient client, NamespaceTable namespaceTable, DataTypeTree dataTypeTree) {
        this(client, namespaceTable, dataTypeTree, DynamicCodecFactory::create);
    }

    public LazyClientDataTypeManager(OpcUaClient client, NamespaceTable namespaceTable, DataTypeTree dataTypeTree, BiFunction<DataType, DataTypeTree, DataTypeCodec> codecFactory) {
        this.client = client;
        this.dataTypeTree = dataTypeTree;
        this.codecFactory = codecFactory;
        new DataTypeInitializer().initialize(namespaceTable, (DataTypeManager)this);
    }

    public void clearFailedResolutions() {
        this.lock.writeLock().lock();
        try {
            this.attemptedResolution.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable DataTypeCodec getCodec(NodeId id) {
        DataTypeCodec codec = super.getCodec(id);
        if (codec != null) {
            return codec;
        }
        if (id.getNamespaceIndex().intValue() == 0) {
            return null;
        }
        if (this.attemptedResolution.contains(id)) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            codec = super.getCodec(id);
            if (codec != null) {
                DataTypeCodec dataTypeCodec = codec;
                return dataTypeCodec;
            }
            if (!this.attemptedResolution.add(id)) {
                DataTypeCodec dataTypeCodec = null;
                return dataTypeCodec;
            }
            DataTypeCodec dataTypeCodec = this.resolveAndRegisterCodec(id);
            return dataTypeCodec;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public @Nullable NodeId getBinaryEncodingId(NodeId dataTypeId) {
        this.ensureRegisteredForDataType(dataTypeId);
        return super.getBinaryEncodingId(dataTypeId);
    }

    public @Nullable NodeId getXmlEncodingId(NodeId dataTypeId) {
        this.ensureRegisteredForDataType(dataTypeId);
        return super.getXmlEncodingId(dataTypeId);
    }

    public @Nullable NodeId getJsonEncodingId(NodeId dataTypeId) {
        this.ensureRegisteredForDataType(dataTypeId);
        return super.getJsonEncodingId(dataTypeId);
    }

    private void ensureRegisteredForDataType(NodeId dataTypeId) {
        if (dataTypeId.getNamespaceIndex().intValue() == 0) {
            return;
        }
        if (super.getBinaryEncodingId(dataTypeId) != null || super.getXmlEncodingId(dataTypeId) != null || super.getJsonEncodingId(dataTypeId) != null) {
            return;
        }
        if (this.attemptedResolution.contains(dataTypeId)) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.attemptedResolution.contains(dataTypeId)) {
                return;
            }
            this.attemptedResolution.add(dataTypeId);
            this.resolveAndRegisterCodecFromDataTypeId(dataTypeId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private @Nullable DataTypeCodec resolveAndRegisterCodec(NodeId id) {
        try {
            DataType dataType = this.dataTypeTree.getDataType(id);
            if (dataType == null || dataType.getDataTypeDefinition() == null) {
                NodeId dataTypeId = this.browseDataTypeIdForEncoding(id);
                if (dataTypeId == null) {
                    LOGGER.debug("No DataType found for encoding {}", (Object)id);
                    return null;
                }
                dataType = this.dataTypeTree.getDataType(dataTypeId);
            }
            if (dataType == null || dataType.getDataTypeDefinition() == null) {
                LOGGER.debug("No DataTypeDefinition available for {}", (Object)id);
                return null;
            }
            return this.createAndRegisterCodec(dataType);
        }
        catch (Exception e) {
            LOGGER.debug("Error resolving codec for {}: {}", (Object)id, (Object)e.getMessage());
            return null;
        }
    }

    private void resolveAndRegisterCodecFromDataTypeId(NodeId dataTypeId) {
        try {
            DataType dataType = this.dataTypeTree.getDataType(dataTypeId);
            if (dataType != null && dataType.getDataTypeDefinition() != null) {
                this.createAndRegisterCodec(dataType);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error resolving codec for DataType {}: {}", (Object)dataTypeId, (Object)e.getMessage());
        }
    }

    private @Nullable DataTypeCodec createAndRegisterCodec(DataType dataType) {
        NodeId binaryEncodingId = LazyClientDataTypeManager.getBinaryEncodingIdFromDataType(dataType);
        DataTypeCodec codec = this.codecFactory.apply(dataType, this.dataTypeTree);
        super.registerType(dataType.getNodeId(), codec, binaryEncodingId, dataType.getXmlEncodingId(), dataType.getJsonEncodingId());
        LOGGER.debug("Lazily registered codec for: name={}, dataTypeId={}", (Object)dataType.getBrowseName(), (Object)dataType.getNodeId());
        return codec;
    }

    private static @Nullable NodeId getBinaryEncodingIdFromDataType(DataType dataType) {
        DataTypeDefinition dataTypeDefinition;
        NodeId binaryEncodingId = dataType.getBinaryEncodingId();
        if (binaryEncodingId == null && (dataTypeDefinition = dataType.getDataTypeDefinition()) instanceof StructureDefinition) {
            StructureDefinition definition = (StructureDefinition)dataTypeDefinition;
            binaryEncodingId = definition.getDefaultEncodingId();
        }
        return binaryEncodingId;
    }

    private @Nullable NodeId browseDataTypeIdForEncoding(NodeId encodingId) {
        try {
            BrowseDescription bd = new BrowseDescription(encodingId, BrowseDirection.Inverse, NodeIds.HasEncoding, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.DataType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()));
            BrowseResult result = this.client.browse(bd);
            if (result.getStatusCode().isGood() && result.getReferences() != null && result.getReferences().length > 0) {
                return result.getReferences()[0].getNodeId().toNodeId(this.client.getNamespaceTable()).orElse(null);
            }
            LOGGER.debug("No DataType found via inverse HasEncoding for encoding {}", (Object)encodingId);
        }
        catch (UaException e) {
            LOGGER.debug("Failed to browse DataType for encoding {}: {}", (Object)encodingId, (Object)e.getMessage());
        }
        return null;
    }
}

