/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import org.eclipse.milo.opcua.sdk.client.CodecFactory;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.typetree.LazyClientDataTypeManager;
import org.eclipse.milo.opcua.sdk.core.types.codec.DynamicCodecFactory;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface DataTypeManagerFactory {
    public DataTypeManager create(OpcUaClient var1, NamespaceTable var2, DataTypeTree var3) throws UaException;

    public static DataTypeManagerFactory eager() {
        return DataTypeManagerFactory.eager(new DefaultInitializer());
    }

    public static DataTypeManagerFactory eager(CodecFactory codecFactory) {
        return DataTypeManagerFactory.eager(new DefaultInitializer(codecFactory));
    }

    public static DataTypeManagerFactory eager(Initializer initializer) {
        return (client, namespaceTable, dataTypeTree) -> {
            DataTypeManager dataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)namespaceTable);
            initializer.initialize(namespaceTable, dataTypeTree, dataTypeManager);
            return dataTypeManager;
        };
    }

    public static DataTypeManagerFactory lazy() {
        return DataTypeManagerFactory.lazy(DynamicCodecFactory::create);
    }

    public static DataTypeManagerFactory lazy(CodecFactory codecFactory) {
        return (client, namespaceTable, dataTypeTree) -> new LazyClientDataTypeManager(client, namespaceTable, dataTypeTree, codecFactory::create);
    }

    public static class DefaultInitializer
    implements Initializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInitializer.class);
        private final CodecFactory codecFactory;

        public DefaultInitializer() {
            this(DynamicCodecFactory::create);
        }

        public DefaultInitializer(CodecFactory codecFactory) {
            this.codecFactory = codecFactory;
        }

        @Override
        public void initialize(NamespaceTable namespaceTable, DataTypeTree dataTypeTree, DataTypeManager dataTypeManager) {
            Tree structureNode = dataTypeTree.getTreeNode(NodeIds.Structure);
            if (structureNode != null) {
                structureNode.traverse(dataType -> {
                    if (dataType.getDataTypeDefinition() != null) {
                        LOGGER.debug("Registering type: name={}, dataTypeId={}", (Object)dataType.getBrowseName(), (Object)dataType.getNodeId());
                        String namespaceUri = namespaceTable.get((UNumber)dataType.getNodeId().getNamespaceIndex());
                        if (namespaceUri == null) {
                            throw new UaRuntimeException(0x80010000L, "DataType namespace not registered: " + dataType.getNodeId().toParseableString());
                        }
                        dataTypeManager.registerType(dataType.getNodeId(), this.codecFactory.create((DataType)dataType, dataTypeTree), DefaultInitializer.getBinaryEncodingId(dataType), dataType.getXmlEncodingId(), dataType.getJsonEncodingId());
                    }
                });
            } else {
                LOGGER.warn("Structure (i=22) not found in the DataType tree; is the Server's DataType hierarchy sane?");
            }
        }

        private static NodeId getBinaryEncodingId(DataType dataType) {
            DataTypeDefinition dataTypeDefinition;
            NodeId binaryEncodingId = dataType.getBinaryEncodingId();
            if (binaryEncodingId == null && (dataTypeDefinition = dataType.getDataTypeDefinition()) instanceof StructureDefinition) {
                StructureDefinition definition = (StructureDefinition)dataTypeDefinition;
                binaryEncodingId = definition.getDefaultEncodingId();
            }
            return binaryEncodingId;
        }
    }

    public static interface Initializer {
        public void initialize(NamespaceTable var1, DataTypeTree var2, DataTypeManager var3) throws UaException;
    }
}

