/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

class ClientObjectType
implements ObjectType {
    private final QualifiedName browseName;
    private final NodeId nodeId;
    private final Boolean isAbstract;

    public ClientObjectType(QualifiedName browseName, NodeId nodeId, Boolean isAbstract) {
        this.browseName = browseName;
        this.nodeId = nodeId;
        this.isAbstract = isAbstract;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientObjectType that = (ClientObjectType)o;
        return this.browseName.equals((Object)that.browseName) && this.nodeId.equals((Object)that.nodeId) && Objects.equals(this.isAbstract, that.isAbstract);
    }

    public int hashCode() {
        return Objects.hash(this.browseName, this.nodeId, this.isAbstract);
    }

    public String toString() {
        return new StringJoiner(", ", ClientObjectType.class.getSimpleName() + "{", "}").add("browseName=" + String.valueOf(this.browseName)).add("nodeId=" + String.valueOf(this.nodeId)).add("isAbstract=" + this.isAbstract).toString();
    }
}

