/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.jspecify.annotations.Nullable;

class ClientDataType
implements DataType {
    private final QualifiedName browseName;
    private final NodeId nodeId;
    private final NodeId binaryEncodingId;
    private final NodeId xmlEncodingId;
    private final NodeId jsonEncodingId;
    private final DataTypeDefinition dataTypeDefinition;
    private final Boolean isAbstract;

    public ClientDataType(QualifiedName browseName, NodeId nodeId, NodeId binaryEncodingId, NodeId xmlEncodingId, NodeId jsonEncodingId, DataTypeDefinition dataTypeDefinition, Boolean isAbstract) {
        this.browseName = browseName;
        this.nodeId = nodeId;
        this.binaryEncodingId = binaryEncodingId;
        this.xmlEncodingId = xmlEncodingId;
        this.jsonEncodingId = jsonEncodingId;
        this.dataTypeDefinition = dataTypeDefinition;
        this.isAbstract = isAbstract;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public @Nullable NodeId getBinaryEncodingId() {
        return this.binaryEncodingId;
    }

    public @Nullable NodeId getXmlEncodingId() {
        return this.xmlEncodingId;
    }

    public @Nullable NodeId getJsonEncodingId() {
        return this.jsonEncodingId;
    }

    public @Nullable DataTypeDefinition getDataTypeDefinition() {
        return this.dataTypeDefinition;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientDataType dataType = (ClientDataType)o;
        return this.browseName.equals((Object)dataType.browseName) && this.nodeId.equals((Object)dataType.nodeId) && Objects.equals(this.binaryEncodingId, dataType.binaryEncodingId) && Objects.equals(this.xmlEncodingId, dataType.xmlEncodingId) && Objects.equals(this.jsonEncodingId, dataType.jsonEncodingId) && Objects.equals(this.dataTypeDefinition, dataType.dataTypeDefinition) && Objects.equals(this.isAbstract, dataType.isAbstract);
    }

    public int hashCode() {
        return Objects.hash(this.browseName, this.nodeId, this.binaryEncodingId, this.xmlEncodingId, this.jsonEncodingId, this.dataTypeDefinition, this.isAbstract);
    }

    public String toString() {
        return new StringJoiner(", ", ClientDataType.class.getSimpleName() + "{", "}").add("browseName=" + String.valueOf(this.browseName)).add("nodeId=" + String.valueOf(this.nodeId)).add("binaryEncodingId=" + String.valueOf(this.binaryEncodingId)).add("xmlEncodingId=" + String.valueOf(this.xmlEncodingId)).add("jsonEncodingId=" + String.valueOf(this.jsonEncodingId)).add("dataTypeDefinition=" + String.valueOf(this.dataTypeDefinition)).add("isAbstract=" + this.isAbstract).toString();
    }
}

