/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OperationLimits;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientBrowseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBrowseUtils.class);

    private ClientBrowseUtils() {
    }

    static List<DataValue> readWithOperationLimits(OpcUaClient client, List<ReadValueId> readValueIds, OperationLimits limits) {
        if (readValueIds.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("readWithOperationLimits: {}", (Object)readValueIds.size());
        int partitionSize = limits.maxNodesPerRead().map(UInteger::intValue).filter(v -> v > 0).orElse(Integer.MAX_VALUE);
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        Lists.partition(readValueIds, (int)partitionSize).forEach(partitionList -> {
            try {
                ReadResponse response = client.read(0.0, TimestampsToReturn.Neither, (List<ReadValueId>)partitionList);
                DataValue[] results = response.getResults();
                Collections.addAll(values, Objects.requireNonNull(results));
            }
            catch (UaException e) {
                LOGGER.debug("Read failed: {}", (Object)e.getMessage(), (Object)e);
                DataValue value = new DataValue(e.getStatusCode());
                values.addAll(Collections.nCopies(partitionList.size(), value));
            }
        });
        return values;
    }

    static List<List<ReferenceDescription>> browseWithOperationLimits(OpcUaClient client, List<BrowseDescription> browseDescriptions, OperationLimits limits) {
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("browseWithOperationLimits: {}", (Object)browseDescriptions.size());
        int partitionSize = limits.maxNodesPerBrowse().map(UInteger::intValue).filter(v -> v > 0).orElse(Integer.MAX_VALUE);
        ArrayList<List<ReferenceDescription>> references = new ArrayList<List<ReferenceDescription>>();
        Lists.partition(browseDescriptions, (int)partitionSize).forEach(partitionList -> references.addAll(ClientBrowseUtils.browse(client, partitionList)));
        return references;
    }

    static List<List<ReferenceDescription>> browse(OpcUaClient client, List<BrowseDescription> browseDescriptions) {
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        ArrayList<List<ReferenceDescription>> referenceDescriptionLists = new ArrayList<List<ReferenceDescription>>();
        try {
            client.browse(browseDescriptions).forEach(result -> {
                if (result.getStatusCode().isGood()) {
                    ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
                    ReferenceDescription[] refs = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                    Collections.addAll(references, refs);
                    ByteString continuationPoint = result.getContinuationPoint();
                    List<ReferenceDescription> nextRefs = ClientBrowseUtils.maybeBrowseNext(client, continuationPoint);
                    references.addAll(nextRefs);
                    referenceDescriptionLists.add(references);
                } else {
                    referenceDescriptionLists.add(List.of());
                }
            });
        }
        catch (UaException e) {
            referenceDescriptionLists.addAll(Collections.nCopies(browseDescriptions.size(), List.of()));
        }
        return referenceDescriptionLists;
    }

    static List<ReferenceDescription> maybeBrowseNext(OpcUaClient client, ByteString continuationPoint) {
        ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
        while (continuationPoint != null && continuationPoint.isNotNull()) {
            try {
                BrowseNextResponse response = client.browseNext(false, List.of(continuationPoint));
                BrowseResult result = Objects.requireNonNull(response.getResults())[0];
                ReferenceDescription[] rds = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                references.addAll(List.of(rds));
                continuationPoint = result.getContinuationPoint();
            }
            catch (Exception e) {
                LOGGER.warn("BrowseNext failed: {}", (Object)e.getMessage(), (Object)e);
                return references;
            }
        }
        return references;
    }
}

