/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.UaSession;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ClientHandleSequence;
import org.eclipse.milo.opcua.sdk.client.subscriptions.MonitoredItemServiceOperationResult;
import org.eclipse.milo.opcua.sdk.client.subscriptions.MonitoredItemSynchronizationException;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.core.util.TaskQueue;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.shaded.com.google.common.primitives.Ints;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaSubscription {
    private static final int DEFAULT_MAX_MONITORED_ITEMS_PER_CALL = 10000;
    private static final UInteger DEFAULT_MAX_NOTIFICATIONS_PER_PUBLISH = Unsigned.uint((int)65535);
    private static final UByte DEFAULT_PRIORITY = Unsigned.ubyte((int)0);
    private static final double DEFAULT_PUBLISHING_INTERVAL = 1000.0;
    private static final double DEFAULT_TARGET_KEEP_ALIVE_INTERVAL = 10000.0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile SyncState syncState = SyncState.INITIAL;
    private volatile @Nullable ServerState serverState;
    private volatile Modifications modifications;
    private volatile WatchdogTimer watchdogTimer;
    private final Map<UInteger, OpcUaMonitoredItem> monitoredItems = new ConcurrentHashMap<UInteger, OpcUaMonitoredItem>();
    private final Set<OpcUaMonitoredItem> itemsToDelete = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ClientHandleSequence clientHandleSequence = new ClientHandleSequence(this.monitoredItems::containsKey);
    private volatile Double publishingInterval = 1000.0;
    private volatile UInteger maxKeepAliveCount = OpcUaSubscription.calculateMaxKeepAliveCount(this.publishingInterval, 10000.0);
    private volatile UInteger lifetimeCount = OpcUaSubscription.calculateLifetimeCount(this.maxKeepAliveCount);
    private volatile UInteger maxNotificationsPerPublish = DEFAULT_MAX_NOTIFICATIONS_PER_PUBLISH;
    private volatile UByte priority = DEFAULT_PRIORITY;
    private volatile boolean lifetimeAndKeepAliveCalculated = true;
    private volatile double watchdogMultiplier = 1.5;
    private volatile UInteger maxMonitoredItemsPerCall = Unsigned.uint((int)10000);
    private final Lazy<UInteger> monitoredItemPartitionSize = new Lazy();
    private volatile @Nullable Object userObject;
    private volatile @Nullable SubscriptionListener listener;
    private final TaskQueue deliveryQueue;
    private final OpcUaClient client;

    public OpcUaSubscription(OpcUaClient client) {
        this.client = client;
        this.deliveryQueue = new TaskQueue((Executor)client.getTransport().getConfig().getExecutor());
    }

    public OpcUaSubscription(OpcUaClient client, double publishingInterval) {
        this.client = client;
        this.publishingInterval = publishingInterval;
        this.deliveryQueue = new TaskQueue((Executor)client.getTransport().getConfig().getExecutor());
    }

    public OpcUaClient getClient() {
        return this.client;
    }

    public void create() throws UaException {
        if (this.syncState == SyncState.INITIAL) {
            if (this.maxKeepAliveCount == null) {
                this.maxKeepAliveCount = OpcUaSubscription.calculateMaxKeepAliveCount(this.publishingInterval, 10000.0);
            }
            if (this.lifetimeCount == null) {
                this.lifetimeCount = OpcUaSubscription.calculateLifetimeCount(this.maxKeepAliveCount);
            }
        } else {
            throw new UaException(2158952448L);
        }
        CreateSubscriptionResponse response = this.client.createSubscription(this.publishingInterval, this.lifetimeCount, this.maxKeepAliveCount, this.maxNotificationsPerPublish, true, this.priority);
        this.syncState = this.monitoredItems.isEmpty() ? SyncState.SYNCHRONIZED : SyncState.UNSYNCHRONIZED;
        this.serverState = new ServerState(response.getSubscriptionId(), response.getRevisedPublishingInterval(), response.getRevisedLifetimeCount(), response.getRevisedMaxKeepAliveCount(), this.maxNotificationsPerPublish, this.priority, true);
        this.watchdogTimer = new WatchdogTimer();
        this.client.addSessionActivityListener(this.watchdogTimer);
        this.resetWatchdogTimer();
        this.client.addSubscription(this);
        this.client.getPublishingManager().addSubscription(this);
    }

    public CompletionStage<Unit> createAsync() {
        return FutureUtils.supplyAsyncCompose(() -> {
            try {
                this.create();
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            catch (UaException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, (Executor)this.client.getTransport().getConfig().getExecutor());
    }

    public void modify() throws UaException {
        if (this.syncState == SyncState.INITIAL) {
            throw new UaException(2158952448L);
        }
        if (this.syncState == SyncState.UNSYNCHRONIZED) {
            ServerState serverState = this.serverState;
            if (serverState == null) {
                throw new UaException(2158952448L);
            }
            Modifications diff = this.modifications;
            this.modifications = null;
            assert (diff != null);
            ModifySubscriptionResponse response = this.client.modifySubscription(serverState.getSubscriptionId(), diff.publishingInterval().orElse(serverState.getPublishingInterval()), diff.lifetimeCount().orElse(serverState.getLifetimeCount()), diff.maxKeepAliveCount().orElse(serverState.getMaxKeepAliveCount()), diff.maxNotificationsPerPublish().orElse(this.maxNotificationsPerPublish), diff.priority().orElse(this.priority));
            this.resetWatchdogTimer();
            this.serverState = new ServerState(serverState.getSubscriptionId(), response.getRevisedPublishingInterval(), response.getRevisedLifetimeCount(), response.getRevisedMaxKeepAliveCount(), this.maxNotificationsPerPublish, this.priority, serverState.isPublishingEnabled());
            if (this.modifications == null) {
                this.syncState = SyncState.SYNCHRONIZED;
            }
        }
    }

    public CompletionStage<Unit> modifyAsync() {
        return FutureUtils.supplyAsyncCompose(() -> {
            try {
                this.modify();
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            catch (UaException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, (Executor)this.client.getTransport().getConfig().getExecutor());
    }

    public void delete() throws UaException {
        if (this.syncState != SyncState.INITIAL) {
            ServerState serverState = this.serverState;
            if (serverState == null) {
                throw new UaException(2158952448L);
            }
            DeleteSubscriptionsResponse response = this.client.deleteSubscriptions(List.of(serverState.getSubscriptionId()));
            StatusCode result = Objects.requireNonNull(response.getResults())[0];
            if (result.isGood() || result.value() == 0x80280000L) {
                this.reset();
            }
            if (!result.isGood()) {
                throw new UaException(result);
            }
        }
    }

    public CompletionStage<Unit> deleteAsync() {
        return FutureUtils.supplyAsyncCompose(() -> {
            try {
                this.delete();
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            catch (UaException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, (Executor)this.client.getTransport().getConfig().getExecutor());
    }

    public void addMonitoredItem(OpcUaMonitoredItem item) {
        Optional<UInteger> existingHandle = item.getClientHandle();
        if (existingHandle.isPresent()) {
            UInteger handle = existingHandle.get();
            if (this.monitoredItems.get(handle) == item) {
                return;
            }
            if (this.itemsToDelete.remove(item)) {
                this.monitoredItems.put(handle, item);
            }
        } else {
            UInteger clientHandle = this.clientHandleSequence.nextClientHandle();
            item.setClientHandle(clientHandle);
            this.monitoredItems.put(clientHandle, item);
            if (this.syncState != SyncState.INITIAL) {
                this.syncState = SyncState.UNSYNCHRONIZED;
            }
        }
    }

    public void addMonitoredItems(List<OpcUaMonitoredItem> items) {
        items.forEach(this::addMonitoredItem);
    }

    public void removeMonitoredItem(OpcUaMonitoredItem item) {
        OpcUaMonitoredItem removedItem = item.getClientHandle().map(this.monitoredItems::remove).orElse(null);
        if (removedItem != null) {
            this.itemsToDelete.add(removedItem);
            if (this.syncState != SyncState.INITIAL) {
                this.syncState = SyncState.UNSYNCHRONIZED;
            }
        }
    }

    public void removeMonitoredItems(List<OpcUaMonitoredItem> items) {
        items.forEach(this::removeMonitoredItem);
    }

    public void synchronizeMonitoredItems() throws MonitoredItemSynchronizationException {
        List<MonitoredItemServiceOperationResult> deleteResults = this.deleteMonitoredItems();
        List<MonitoredItemServiceOperationResult> modifyResults = this.modifyMonitoredItems();
        List<MonitoredItemServiceOperationResult> createResults = this.createMonitoredItems();
        if (Stream.of(deleteResults, modifyResults, createResults).flatMap(Collection::stream).anyMatch(r -> !r.serviceResult().isGood() || !r.operationResult().orElseThrow().isGood())) {
            throw new MonitoredItemSynchronizationException("failed to synchronize one or more MonitoredItems", createResults, modifyResults, deleteResults);
        }
    }

    public List<MonitoredItemServiceOperationResult> createMonitoredItems() {
        List<OpcUaMonitoredItem> itemsToCreate = this.monitoredItems.values().stream().filter(item -> item.getSyncState() == OpcUaMonitoredItem.SyncState.INITIAL).collect(Collectors.toList());
        return this.createMonitoredItems(itemsToCreate);
    }

    public List<MonitoredItemServiceOperationResult> createMonitoredItems(Predicate<OpcUaMonitoredItem> filter) {
        List<OpcUaMonitoredItem> itemsToCreate = this.monitoredItems.values().stream().filter(item -> item.getSyncState() == OpcUaMonitoredItem.SyncState.INITIAL).filter(filter).collect(Collectors.toList());
        return this.createMonitoredItems(itemsToCreate);
    }

    private List<MonitoredItemServiceOperationResult> createMonitoredItems(List<OpcUaMonitoredItem> itemsToCreate) {
        if (itemsToCreate.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MonitoredItemServiceOperationResult> serviceOperationsResults = new ArrayList<MonitoredItemServiceOperationResult>(itemsToCreate.size());
        ServerState serverState = this.serverState;
        if (serverState == null) {
            this.logger.debug("Bad_InvalidState: subscription not created yet");
            for (OpcUaMonitoredItem item : itemsToCreate) {
                serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item, new StatusCode(2158952448L), null));
            }
            return serviceOperationsResults;
        }
        UInteger partitionSize = this.getMonitoredItemPartitionSize();
        List partitions = Lists.partition(itemsToCreate, (int)partitionSize.intValue()).toList();
        for (List partition : partitions) {
            try {
                this.logger.debug("id={}, createMonitoredItems partition.size(): {}", (Object)serverState.getSubscriptionId(), (Object)partition.size());
                CreateMonitoredItemsResponse response = this.client.createMonitoredItems(serverState.getSubscriptionId(), TimestampsToReturn.Both, partition.stream().map(OpcUaMonitoredItem::newCreateRequest).collect(Collectors.toList()));
                MonitoredItemCreateResult[] results = Objects.requireNonNull(response.getResults());
                for (int i = 0; i < results.length; ++i) {
                    MonitoredItemCreateResult result = results[i];
                    OpcUaMonitoredItem monitoredItem = (OpcUaMonitoredItem)partition.get(i);
                    monitoredItem.applyCreateResult(result);
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult(monitoredItem, StatusCode.GOOD, result.getStatusCode()));
                }
            }
            catch (UaException e) {
                for (OpcUaMonitoredItem item : partition) {
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item, e.getStatusCode(), null));
                }
            }
        }
        return serviceOperationsResults;
    }

    public List<MonitoredItemServiceOperationResult> modifyMonitoredItems() {
        List<OpcUaMonitoredItem> itemsToModify = this.monitoredItems.values().stream().filter(item -> item.getSyncState() == OpcUaMonitoredItem.SyncState.UNSYNCHRONIZED).collect(Collectors.toList());
        if (!itemsToModify.isEmpty()) {
            return this.modifyMonitoredItems(itemsToModify);
        }
        return Collections.emptyList();
    }

    private List<MonitoredItemServiceOperationResult> modifyMonitoredItems(List<OpcUaMonitoredItem> itemsToModify) {
        ArrayList<MonitoredItemServiceOperationResult> serviceOperationsResults = new ArrayList<MonitoredItemServiceOperationResult>(itemsToModify.size());
        ServerState serverState = this.serverState;
        if (serverState == null) {
            for (OpcUaMonitoredItem item : itemsToModify) {
                serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item, new StatusCode(2158952448L), null));
            }
            return serviceOperationsResults;
        }
        UInteger partitionSize = this.getMonitoredItemPartitionSize();
        List partitions = Lists.partition(itemsToModify, (int)partitionSize.intValue()).toList();
        for (List partition : partitions) {
            try {
                this.logger.debug("id={}, modifyMonitoredItems partition.size(): {}", (Object)serverState.subscriptionId, (Object)partition.size());
                ModifyMonitoredItemsResponse response = this.client.modifyMonitoredItems(serverState.getSubscriptionId(), TimestampsToReturn.Both, partition.stream().map(OpcUaMonitoredItem::newModifyRequest).collect(Collectors.toList()));
                MonitoredItemModifyResult[] results = Objects.requireNonNull(response.getResults());
                for (int i = 0; i < results.length; ++i) {
                    MonitoredItemModifyResult result = results[i];
                    OpcUaMonitoredItem monitoredItem = (OpcUaMonitoredItem)partition.get(i);
                    monitoredItem.applyModifyResult(result);
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult(monitoredItem, StatusCode.GOOD, result.getStatusCode()));
                }
            }
            catch (UaException e) {
                for (OpcUaMonitoredItem item : partition) {
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item, e.getStatusCode(), null));
                }
            }
        }
        return serviceOperationsResults;
    }

    public List<MonitoredItemServiceOperationResult> deleteMonitoredItems() {
        List<OpcUaMonitoredItem> itemsToDelete = this.itemsToDelete.stream().filter(item -> item.getSyncState() != OpcUaMonitoredItem.SyncState.INITIAL).collect(Collectors.toList());
        this.itemsToDelete.clear();
        if (!itemsToDelete.isEmpty()) {
            return this.deleteMonitoredItems(itemsToDelete);
        }
        return Collections.emptyList();
    }

    private List<MonitoredItemServiceOperationResult> deleteMonitoredItems(List<OpcUaMonitoredItem> itemsToDelete) {
        ArrayList<MonitoredItemServiceOperationResult> serviceOperationsResults = new ArrayList<MonitoredItemServiceOperationResult>(itemsToDelete.size());
        ServerState serverState = this.serverState;
        if (serverState == null) {
            for (OpcUaMonitoredItem item2 : itemsToDelete) {
                serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item2, new StatusCode(2158952448L), null));
            }
            return serviceOperationsResults;
        }
        UInteger partitionSize = this.getMonitoredItemPartitionSize();
        List partitions = Lists.partition(itemsToDelete, (int)partitionSize.intValue()).toList();
        for (List partition : partitions) {
            try {
                this.logger.debug("id={}, deleteMonitoredItems partition.size(): {}", (Object)serverState.subscriptionId, (Object)partition.size());
                DeleteMonitoredItemsResponse response = this.client.deleteMonitoredItems(serverState.getSubscriptionId(), partition.stream().map(item -> item.getMonitoredItemId().orElseThrow()).collect(Collectors.toList()));
                StatusCode[] results = Objects.requireNonNull(response.getResults());
                for (int i = 0; i < results.length; ++i) {
                    StatusCode result = results[i];
                    ((OpcUaMonitoredItem)partition.get(i)).applyDeleteResult(result);
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult((OpcUaMonitoredItem)partition.get(i), StatusCode.GOOD, result));
                }
            }
            catch (UaException e) {
                for (OpcUaMonitoredItem item3 : partition) {
                    serviceOperationsResults.add(new MonitoredItemServiceOperationResult(item3, e.getStatusCode(), null));
                }
            }
        }
        return serviceOperationsResults;
    }

    private UInteger getMonitoredItemPartitionSize() {
        return (UInteger)this.monitoredItemPartitionSize.get(() -> {
            UInteger serverMaxMonitoredItemsPerCall;
            try {
                serverMaxMonitoredItemsPerCall = this.client.getOperationLimits().maxMonitoredItemsPerCall().orElse(UInteger.MAX);
                if (serverMaxMonitoredItemsPerCall.intValue() == 0) {
                    serverMaxMonitoredItemsPerCall = UInteger.MAX;
                }
            }
            catch (UaException e) {
                serverMaxMonitoredItemsPerCall = UInteger.MAX;
            }
            int configuredMax = Ints.saturatedCast((long)this.maxMonitoredItemsPerCall.longValue());
            int serverMax = Ints.saturatedCast((long)serverMaxMonitoredItemsPerCall.longValue());
            return Unsigned.uint((int)Math.min(configuredMax, serverMax));
        });
    }

    public List<MonitoredItemServiceOperationResult> setMonitoringMode(MonitoringMode monitoringMode, List<OpcUaMonitoredItem> monitoredItems) {
        if (monitoredItems.isEmpty()) {
            return Collections.emptyList();
        }
        if (monitoredItems.stream().anyMatch(item -> item.getSyncState() == OpcUaMonitoredItem.SyncState.INITIAL)) {
            throw new IllegalArgumentException("MonitoredItems must exist before setting MonitoringMode");
        }
        ArrayList<MonitoredItemServiceOperationResult> serviceOperationResults = new ArrayList<MonitoredItemServiceOperationResult>(monitoredItems.size());
        ServerState serverState = this.serverState;
        if (serverState == null) {
            for (OpcUaMonitoredItem item2 : monitoredItems) {
                serviceOperationResults.add(new MonitoredItemServiceOperationResult(item2, new StatusCode(2158952448L), null));
            }
            return serviceOperationResults;
        }
        UInteger partitionSize = this.getMonitoredItemPartitionSize();
        List partitions = Lists.partition(monitoredItems, (int)partitionSize.intValue()).toList();
        for (List partition : partitions) {
            try {
                this.logger.debug("id={}, setMonitoringMode partition.size(): {}", (Object)serverState.subscriptionId, (Object)partition.size());
                SetMonitoringModeResponse response = this.client.setMonitoringMode(serverState.getSubscriptionId(), monitoringMode, partition.stream().map(item -> item.getMonitoredItemId().orElseThrow()).collect(Collectors.toList()));
                StatusCode[] results = Objects.requireNonNull(response.getResults());
                for (int i = 0; i < results.length; ++i) {
                    StatusCode result = results[i];
                    OpcUaMonitoredItem item3 = (OpcUaMonitoredItem)partition.get(i);
                    item3.applySetMonitoringModeResult(result);
                    if (result.isGood()) {
                        item3.setMonitoringMode(monitoringMode);
                    }
                    serviceOperationResults.add(new MonitoredItemServiceOperationResult(item3, StatusCode.GOOD, result));
                }
            }
            catch (UaException e) {
                for (OpcUaMonitoredItem item4 : partition) {
                    item4.applySetMonitoringModeResult(e.getStatusCode());
                    serviceOperationResults.add(new MonitoredItemServiceOperationResult(item4, e.getStatusCode(), null));
                }
            }
        }
        return serviceOperationResults;
    }

    public void setPublishingMode(boolean enabled) throws UaException {
        if (this.syncState == SyncState.INITIAL) {
            throw new UaException(2158952448L);
        }
        ServerState serverState = this.serverState;
        if (serverState == null) {
            throw new UaException(2158952448L);
        }
        SetPublishingModeResponse response = this.client.setPublishingMode(enabled, List.of(serverState.getSubscriptionId()));
        StatusCode result = Objects.requireNonNull(response.getResults())[0];
        if (!result.isGood()) {
            throw new UaException(result);
        }
        this.serverState = new ServerState(serverState.getSubscriptionId(), serverState.getPublishingInterval(), serverState.getLifetimeCount(), serverState.getMaxKeepAliveCount(), this.maxNotificationsPerPublish, this.priority, enabled);
    }

    public CompletionStage<Unit> setPublishingModeAsync(boolean enabled) {
        return FutureUtils.supplyAsyncCompose(() -> {
            try {
                this.setPublishingMode(enabled);
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            catch (UaException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, (Executor)this.client.getTransport().getConfig().getExecutor());
    }

    public SyncState getSyncState() {
        return this.syncState;
    }

    public Optional<ServerState> getServerState() {
        return Optional.ofNullable(this.serverState);
    }

    public List<OpcUaMonitoredItem> getMonitoredItems() {
        return List.copyOf(this.monitoredItems.values());
    }

    public Double getPublishingInterval() {
        return this.publishingInterval;
    }

    public UInteger getLifetimeCount() {
        return this.lifetimeCount;
    }

    public UInteger getMaxKeepAliveCount() {
        return this.maxKeepAliveCount;
    }

    public UByte getPriority() {
        return this.priority;
    }

    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public Optional<Boolean> isPublishingEnabled() {
        return this.getServerState().map(ServerState::isPublishingEnabled);
    }

    public Optional<UInteger> getSubscriptionId() {
        return this.getServerState().map(ServerState::getSubscriptionId);
    }

    public Optional<Double> getRevisedPublishingInterval() {
        return this.getServerState().map(ServerState::getPublishingInterval);
    }

    public Optional<UInteger> getRevisedLifetimeCount() {
        return this.getServerState().map(ServerState::getLifetimeCount);
    }

    public Optional<UInteger> getRevisedMaxKeepAliveCount() {
        return this.getServerState().map(ServerState::getMaxKeepAliveCount);
    }

    public void setPublishingInterval(Double publishingInterval) {
        this.publishingInterval = publishingInterval;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.publishingInterval = publishingInterval;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
        if (this.lifetimeAndKeepAliveCalculated) {
            UInteger maxKeepAliveCount = OpcUaSubscription.calculateMaxKeepAliveCount(publishingInterval, 10000.0);
            UInteger lifetimeCount = OpcUaSubscription.calculateLifetimeCount(maxKeepAliveCount);
            this.setMaxKeepAliveCount(maxKeepAliveCount);
            this.setLifetimeCount(lifetimeCount);
        }
    }

    public void setLifetimeCount(UInteger lifetimeCount) {
        this.lifetimeCount = lifetimeCount;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.lifetimeCount = lifetimeCount;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setMaxKeepAliveCount(UInteger maxKeepAliveCount) {
        this.maxKeepAliveCount = maxKeepAliveCount;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.maxKeepAliveCount = maxKeepAliveCount;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setPriority(UByte priority) {
        this.priority = priority;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.priority = priority;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setMaxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.maxNotificationsPerPublish = maxNotificationsPerPublish;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setLifetimeAndKeepAliveCalculated(boolean lifetimeAndKeepAliveCalculated) {
        this.lifetimeAndKeepAliveCalculated = lifetimeAndKeepAliveCalculated;
    }

    public boolean isLifetimeAndKeepAliveCalculated() {
        return this.lifetimeAndKeepAliveCalculated;
    }

    public void setTargetKeepAliveInterval(double targetKeepAliveInterval) {
        if (this.isLifetimeAndKeepAliveCalculated()) {
            this.setMaxKeepAliveCount(OpcUaSubscription.calculateMaxKeepAliveCount(this.publishingInterval, targetKeepAliveInterval));
            this.setLifetimeCount(OpcUaSubscription.calculateLifetimeCount(this.maxKeepAliveCount));
        }
    }

    public void setMaxMonitoredItemsPerCall(UInteger maxMonitoredItemsPerCall) {
        this.maxMonitoredItemsPerCall = maxMonitoredItemsPerCall;
        this.monitoredItemPartitionSize.reset();
    }

    public void setWatchdogMultiplier(double watchdogMultiplier) {
        this.watchdogMultiplier = Math.max(1.0, watchdogMultiplier);
    }

    public void setSubscriptionListener(@Nullable SubscriptionListener listener) {
        this.listener = listener;
    }

    public void setUserObject(@Nullable Object userObject) {
        this.userObject = userObject;
    }

    public Optional<Object> getUserObject() {
        return Optional.ofNullable(this.userObject);
    }

    public TaskQueue getDeliveryQueue() {
        return this.deliveryQueue;
    }

    public void reset() {
        if (this.syncState != SyncState.INITIAL) {
            this.cancelWatchdogTimer();
            this.client.removeSubscription(this);
            this.client.getPublishingManager().removeSubscription(this);
            this.serverState = null;
            this.modifications = null;
            this.monitoredItemPartitionSize.reset();
            this.monitoredItems.values().forEach(OpcUaMonitoredItem::reset);
            this.syncState = SyncState.INITIAL;
        }
    }

    synchronized void cancelWatchdogTimer() {
        WatchdogTimer watchdog = this.watchdogTimer;
        if (watchdog != null) {
            this.client.removeSessionActivityListener(watchdog);
            watchdog.cancel();
            this.watchdogTimer = null;
            this.logger.debug("id={}, watchdog timer cancelled", this.getServerState().map(ServerState::getSubscriptionId).orElse(null));
        }
    }

    synchronized void resetWatchdogTimer() {
        WatchdogTimer watchdog = this.watchdogTimer;
        if (watchdog != null) {
            watchdog.reset();
            this.logger.trace("id={}, watchdog timer reset", this.getServerState().map(ServerState::getSubscriptionId).orElse(null));
        }
    }

    private static UInteger calculateMaxKeepAliveCount(double publishingInterval, double targetKeepAliveInterval) {
        int count = (int)Math.ceil(targetKeepAliveInterval / Math.max(1.0, publishingInterval));
        return Unsigned.uint((int)Math.max(1, count));
    }

    private static UInteger calculateLifetimeCount(UInteger maxKeepAliveCount) {
        BigInteger lifetimeCount = maxKeepAliveCount.toBigInteger().multiply(BigInteger.valueOf(5L)).min(BigInteger.valueOf(0xFFFFFFFFL));
        return Unsigned.uint((long)lifetimeCount.longValue());
    }

    public String toString() {
        return new StringJoiner(", ", OpcUaSubscription.class.getSimpleName() + "[", "]").add("subscriptionId=" + String.valueOf(this.getSubscriptionId().orElse(null))).add("syncState=" + String.valueOf((Object)this.syncState)).toString();
    }

    void notifyDataReceived(MonitoredItemNotification[] notifications) {
        ArrayList<OpcUaMonitoredItem> items = new ArrayList<OpcUaMonitoredItem>(notifications.length);
        ArrayList<DataValue> values = new ArrayList<DataValue>(notifications.length);
        for (MonitoredItemNotification notification : notifications) {
            UInteger clientHandle = notification.getClientHandle();
            OpcUaMonitoredItem item = this.monitoredItems.get(clientHandle);
            if (item != null) {
                items.add(item);
                values.add(notification.getValue());
                continue;
            }
            this.logger.debug("id={}, received data for unknown ClientHandle: {}", this.getServerState().map(ServerState::getSubscriptionId).orElse(null), (Object)clientHandle);
        }
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            listener.onDataReceived(this, items, values);
        }
        for (int i = 0; i < items.size(); ++i) {
            OpcUaMonitoredItem item = items.get(i);
            DataValue value = values.get(i);
            item.notifyDataValueReceived(value);
        }
    }

    void notifyEventsReceived(EventFieldList[] events) {
        ArrayList<OpcUaMonitoredItem> items = new ArrayList<OpcUaMonitoredItem>(events.length);
        ArrayList<Variant[]> eventValuesList = new ArrayList<Variant[]>(events.length);
        for (EventFieldList event : events) {
            UInteger clientHandle = event.getClientHandle();
            OpcUaMonitoredItem item = this.monitoredItems.get(clientHandle);
            if (item != null) {
                items.add(item);
                eventValuesList.add(event.getEventFields());
                continue;
            }
            this.logger.debug("id={}, received event for unknown ClientHandle: {}", this.getServerState().map(ServerState::getSubscriptionId).orElse(null), (Object)clientHandle);
        }
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            listener.onEventReceived(this, items, eventValuesList);
        }
        for (int i = 0; i < items.size(); ++i) {
            OpcUaMonitoredItem item = items.get(i);
            Variant[] eventValues = eventValuesList.get(i);
            item.notifyEventValuesReceived(eventValues);
        }
    }

    void notifyKeepAliveReceived() {
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            this.deliveryQueue.execute(() -> listener.onKeepAliveReceived(this));
        }
    }

    void notifyStatusChanged(StatusCode status) {
        SubscriptionListener listener;
        if (status.getValue() == 0x800A0000L) {
            this.reset();
        }
        if ((listener = this.listener) != null) {
            this.deliveryQueue.execute(() -> listener.onStatusChanged(this, status));
        }
    }

    void notifyNotificationDataLost() {
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            this.deliveryQueue.execute(() -> listener.onNotificationDataLost(this));
        }
    }

    public void notifyTransferFailed(StatusCode status) {
        this.reset();
        SubscriptionListener listener = this.listener;
        if (listener != null) {
            this.deliveryQueue.execute(() -> listener.onTransferFailed(this, status));
        }
    }

    public static enum SyncState {
        INITIAL,
        SYNCHRONIZED,
        UNSYNCHRONIZED;

    }

    public static class ServerState {
        private final UInteger subscriptionId;
        private final Double publishingInterval;
        private final UInteger lifetimeCount;
        private final UInteger maxKeepAliveCount;
        private final UInteger maxNotificationsPerPublish;
        private final UByte priority;
        private final boolean publishingEnabled;

        private ServerState(UInteger subscriptionId, Double publishingInterval, UInteger lifetimeCount, UInteger maxKeepAliveCount, UInteger maxNotificationsPerPublish, UByte priority, boolean publishingEnabled) {
            this.subscriptionId = subscriptionId;
            this.publishingInterval = publishingInterval;
            this.lifetimeCount = lifetimeCount;
            this.maxKeepAliveCount = maxKeepAliveCount;
            this.maxNotificationsPerPublish = maxNotificationsPerPublish;
            this.priority = priority;
            this.publishingEnabled = publishingEnabled;
        }

        public UInteger getSubscriptionId() {
            return this.subscriptionId;
        }

        public Double getPublishingInterval() {
            return this.publishingInterval;
        }

        public UInteger getLifetimeCount() {
            return this.lifetimeCount;
        }

        public UInteger getMaxKeepAliveCount() {
            return this.maxKeepAliveCount;
        }

        public UInteger getMaxNotificationsPerPublish() {
            return this.maxNotificationsPerPublish;
        }

        public UByte getPriority() {
            return this.priority;
        }

        public boolean isPublishingEnabled() {
            return this.publishingEnabled;
        }
    }

    private class WatchdogTimer
    implements SessionActivityListener {
        private final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();

        private WatchdogTimer() {
        }

        void reset() {
            ScheduledFuture<?> sf = this.scheduledFuture.get();
            if (sf != null) {
                sf.cancel(false);
            }
            this.scheduleNext();
        }

        void cancel() {
            ScheduledFuture sf = this.scheduledFuture.getAndSet(null);
            if (sf != null) {
                sf.cancel(false);
            }
        }

        private void scheduleNext() {
            OpcUaSubscription.this.getServerState().ifPresent(state -> {
                long delay = Math.round(state.publishingInterval * (double)(state.maxKeepAliveCount.longValue() + 1L) * OpcUaSubscription.this.watchdogMultiplier);
                ScheduledFuture<?> nextSf = OpcUaSubscription.this.client.getTransport().getConfig().getScheduledExecutor().schedule(() -> this.notifyWatchdogTimerElapsed(delay), delay, TimeUnit.MILLISECONDS);
                this.scheduledFuture.set(nextSf);
                OpcUaSubscription.this.logger.debug("id={} watchdog timer scheduled for +{}ms", (Object)state.subscriptionId, (Object)delay);
            });
        }

        private void notifyWatchdogTimerElapsed(long delay) {
            SubscriptionListener listener = OpcUaSubscription.this.listener;
            if (listener != null) {
                OpcUaSubscription.this.deliveryQueue.execute(() -> {
                    OpcUaSubscription.this.logger.debug("id={}, watchdog timer expired after {}ms", OpcUaSubscription.this.getServerState().map(ServerState::getSubscriptionId).orElse(null), (Object)delay);
                    listener.onWatchdogTimerElapsed(OpcUaSubscription.this);
                });
            }
        }

        @Override
        public void onSessionActive(UaSession session) {
            this.reset();
            OpcUaSubscription.this.logger.debug("id={}, watchdog timer reset via onSessionActive()", OpcUaSubscription.this.getServerState().map(ServerState::getSubscriptionId).orElse(null));
        }

        @Override
        public void onSessionInactive(UaSession session) {
            this.cancel();
            OpcUaSubscription.this.logger.debug("id={}, watchdog timer cancelled via onSessionInactive()", OpcUaSubscription.this.getServerState().map(ServerState::getSubscriptionId).orElse(null));
        }
    }

    private static class Modifications {
        private volatile @Nullable Double publishingInterval;
        private volatile @Nullable UInteger lifetimeCount;
        private volatile @Nullable UInteger maxKeepAliveCount;
        private volatile @Nullable UInteger maxNotificationsPerPublish;
        private volatile @Nullable UByte priority;

        private Modifications() {
        }

        private Optional<Double> publishingInterval() {
            return Optional.ofNullable(this.publishingInterval);
        }

        private Optional<UInteger> lifetimeCount() {
            return Optional.ofNullable(this.lifetimeCount);
        }

        private Optional<UInteger> maxKeepAliveCount() {
            return Optional.ofNullable(this.maxKeepAliveCount);
        }

        private Optional<UInteger> maxNotificationsPerPublish() {
            return Optional.ofNullable(this.maxNotificationsPerPublish);
        }

        private Optional<UByte> priority() {
            return Optional.ofNullable(this.priority);
        }
    }

    public static interface SubscriptionListener {
        default public void onDataReceived(OpcUaSubscription subscription, List<OpcUaMonitoredItem> items, List<DataValue> values) {
        }

        default public void onEventReceived(OpcUaSubscription subscription, List<OpcUaMonitoredItem> items, List<Variant[]> fields) {
        }

        default public void onKeepAliveReceived(OpcUaSubscription subscription) {
        }

        default public void onNotificationDataLost(OpcUaSubscription subscription) {
        }

        default public void onWatchdogTimerElapsed(OpcUaSubscription subscription) {
        }

        default public void onStatusChanged(OpcUaSubscription subscription, StatusCode status) {
        }

        default public void onTransferFailed(OpcUaSubscription subscription, StatusCode status) {
        }
    }
}

