/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.encoding.DefaultEncodingContext;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.jspecify.annotations.Nullable;

public class OpcUaMonitoredItem {
    private volatile SyncState syncState = SyncState.INITIAL;
    private volatile ServerState serverState;
    private volatile Modifications modifications;
    private volatile @Nullable Object userObject;
    private volatile @Nullable DataValueListener dataValueListener;
    private volatile @Nullable EventValueListener eventValueListener;
    private volatile MonitoringMode monitoringMode = MonitoringMode.Reporting;
    private volatile Double samplingInterval = 1000.0;
    private volatile @Nullable MonitoringFilter filter;
    private volatile UInteger queueSize = Unsigned.uint((int)1);
    private volatile boolean discardOldest = true;
    private volatile @Nullable StatusCode createResult;
    private volatile @Nullable StatusCode modifyResult;
    private volatile @Nullable StatusCode deleteResult;
    private volatile @Nullable StatusCode setMonitoringModeResult;
    private volatile @Nullable UInteger clientHandle;
    private final ReadValueId readValueId;

    public OpcUaMonitoredItem(ReadValueId readValueId) {
        this.readValueId = readValueId;
    }

    public OpcUaMonitoredItem(ReadValueId readValueId, MonitoringMode monitoringMode) {
        this.readValueId = readValueId;
        this.monitoringMode = monitoringMode;
    }

    public void setSamplingInterval(double samplingInterval) {
        this.samplingInterval = samplingInterval;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.samplingInterval = samplingInterval;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setQueueSize(UInteger queueSize) {
        this.queueSize = queueSize;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.queueSize = queueSize;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setDiscardOldest(boolean discardOldest) {
        this.discardOldest = discardOldest;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.discardOldest = discardOldest;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public void setFilter(@Nullable MonitoringFilter filter) {
        this.filter = filter;
        if (this.syncState != SyncState.INITIAL) {
            if (this.modifications == null) {
                this.modifications = new Modifications();
            }
            this.modifications.filter = filter;
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
    }

    public ReadValueId getReadValueId() {
        return this.readValueId;
    }

    public Optional<UInteger> getClientHandle() {
        return Optional.ofNullable(this.clientHandle);
    }

    public Optional<UInteger> getMonitoredItemId() {
        return this.getServerState().map(ServerState::getMonitoredItemId);
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public UInteger getQueueSize() {
        return this.queueSize;
    }

    public boolean getDiscardOldest() {
        return this.discardOldest;
    }

    public @Nullable MonitoringFilter getFilter() {
        return this.filter;
    }

    public Optional<Double> getRevisedSamplingInterval() {
        return this.getServerState().map(ServerState::getSamplingInterval);
    }

    public Optional<UInteger> getRevisedQueueSize() {
        return this.getServerState().map(ServerState::getQueueSize);
    }

    public Optional<ExtensionObject> getFilterResult() {
        return this.getServerState().map(ServerState::getFilterResult);
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public Optional<StatusCode> getCreateResult() {
        return Optional.ofNullable(this.createResult);
    }

    public Optional<StatusCode> getModifyResult() {
        return Optional.ofNullable(this.modifyResult);
    }

    public Optional<StatusCode> getDeleteResult() {
        return Optional.ofNullable(this.deleteResult);
    }

    public Optional<StatusCode> getSetMonitoringModeResult() {
        return Optional.ofNullable(this.setMonitoringModeResult);
    }

    public void setDataValueListener(@Nullable DataValueListener listener) {
        this.dataValueListener = listener;
    }

    public void setEventValueListener(@Nullable EventValueListener listener) {
        this.eventValueListener = listener;
    }

    public void setUserObject(@Nullable Object userObject) {
        this.userObject = userObject;
    }

    public Optional<Object> getUserObject() {
        return Optional.ofNullable(this.userObject);
    }

    void setClientHandle(@Nullable UInteger clientHandle) {
        this.clientHandle = clientHandle;
    }

    void setMonitoringMode(MonitoringMode monitoringMode) {
        this.monitoringMode = monitoringMode;
    }

    public SyncState getSyncState() {
        return this.syncState;
    }

    public Optional<ServerState> getServerState() {
        return Optional.ofNullable(this.serverState);
    }

    MonitoredItemCreateRequest newCreateRequest() {
        if (this.clientHandle == null) {
            throw new IllegalStateException("no clientHandle");
        }
        ExtensionObject filterXo = null;
        MonitoringFilter filter = this.filter;
        if (filter != null) {
            filterXo = ExtensionObject.encode((EncodingContext)DefaultEncodingContext.INSTANCE, (UaStructuredType)filter);
        }
        return new MonitoredItemCreateRequest(this.readValueId, this.monitoringMode, new MonitoringParameters(this.clientHandle, this.samplingInterval, filterXo, this.queueSize, Boolean.valueOf(this.discardOldest)));
    }

    MonitoredItemModifyRequest newModifyRequest() {
        if (this.serverState == null) {
            throw new IllegalStateException("no ServerState");
        }
        if (this.modifications == null) {
            throw new IllegalStateException("no pending modification");
        }
        Double newRequestedSamplingInterval = this.modifications.samplingInterval().orElse(this.samplingInterval);
        MonitoringFilter newFilter = this.modifications.filter().orElse(this.filter);
        UInteger newRequestedQueueSize = this.modifications.queueSize().orElse(this.queueSize);
        Boolean newDiscardOldest = this.modifications.discardOldest().orElse(this.discardOldest);
        ExtensionObject newFilterXo = null;
        if (newFilter != null) {
            newFilterXo = ExtensionObject.encode((EncodingContext)DefaultEncodingContext.INSTANCE, (UaStructuredType)newFilter);
        }
        return new MonitoredItemModifyRequest(this.serverState.monitoredItemId, new MonitoringParameters(this.clientHandle, newRequestedSamplingInterval, newFilterXo, newRequestedQueueSize, newDiscardOldest));
    }

    void applyCreateResult(MonitoredItemCreateResult result) {
        StatusCode statusCode = result.getStatusCode();
        if (statusCode.isGood()) {
            this.serverState = new ServerState(result.getMonitoredItemId(), this.monitoringMode, result.getRevisedSamplingInterval(), result.getFilterResult(), result.getRevisedQueueSize(), this.discardOldest);
            this.syncState = SyncState.SYNCHRONIZED;
        } else {
            this.syncState = SyncState.INITIAL;
        }
        this.createResult = statusCode;
    }

    void applyModifyResult(MonitoredItemModifyResult result) {
        StatusCode statusCode = result.getStatusCode();
        if (statusCode.isGood()) {
            this.modifications = null;
            UInteger monitoredItemId = this.serverState.monitoredItemId;
            this.serverState = new ServerState(monitoredItemId, this.monitoringMode, result.getRevisedSamplingInterval(), result.getFilterResult(), result.getRevisedQueueSize(), this.discardOldest);
            this.syncState = SyncState.SYNCHRONIZED;
        } else {
            this.syncState = SyncState.UNSYNCHRONIZED;
        }
        this.modifyResult = statusCode;
    }

    void applyDeleteResult(StatusCode statusCode) {
        this.syncState = SyncState.INITIAL;
        this.serverState = null;
        this.modifications = null;
        this.clientHandle = null;
        this.deleteResult = statusCode;
    }

    void applySetMonitoringModeResult(StatusCode statusCode) {
        this.setMonitoringModeResult = statusCode;
    }

    void notifyDataValueReceived(DataValue value) {
        DataValueListener listener = this.dataValueListener;
        if (listener != null) {
            listener.onDataReceived(this, value);
        }
    }

    void notifyEventValuesReceived(Variant[] eventValues) {
        EventValueListener listener = this.eventValueListener;
        if (listener != null) {
            listener.onEventReceived(this, eventValues);
        }
    }

    void reset() {
        this.syncState = SyncState.INITIAL;
        this.serverState = null;
        this.modifications = null;
        this.createResult = null;
        this.modifyResult = null;
        this.deleteResult = null;
        this.setMonitoringModeResult = null;
    }

    public static OpcUaMonitoredItem newDataItem(NodeId nodeId) {
        ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
        return new OpcUaMonitoredItem(readValueId);
    }

    public static OpcUaMonitoredItem newDataItem(NodeId nodeId, MonitoringMode monitoringMode) {
        ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
        return new OpcUaMonitoredItem(readValueId, monitoringMode);
    }

    public static OpcUaMonitoredItem newEventItem(NodeId nodeId) {
        return OpcUaMonitoredItem.newEventItem(nodeId, null);
    }

    public static OpcUaMonitoredItem newEventItem(NodeId nodeId, @Nullable EventFilter eventFilter) {
        ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.EventNotifier.uid(), null, QualifiedName.NULL_VALUE);
        OpcUaMonitoredItem item = new OpcUaMonitoredItem(readValueId);
        item.setSamplingInterval(0.0);
        item.setFilter((MonitoringFilter)eventFilter);
        return item;
    }

    public static OpcUaMonitoredItem newEventItem(NodeId nodeId, MonitoringMode monitoringMode, @Nullable EventFilter eventFilter) {
        ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.EventNotifier.uid(), null, QualifiedName.NULL_VALUE);
        OpcUaMonitoredItem item = new OpcUaMonitoredItem(readValueId, monitoringMode);
        item.setSamplingInterval(0.0);
        item.setFilter((MonitoringFilter)eventFilter);
        return item;
    }

    public static enum SyncState {
        INITIAL,
        SYNCHRONIZED,
        UNSYNCHRONIZED;

    }

    static class Modifications {
        private volatile @Nullable Double samplingInterval;
        private volatile @Nullable MonitoringFilter filter;
        private volatile @Nullable UInteger queueSize;
        private volatile @Nullable Boolean discardOldest;

        Modifications() {
        }

        Optional<Double> samplingInterval() {
            return Optional.ofNullable(this.samplingInterval);
        }

        Optional<MonitoringFilter> filter() {
            return Optional.ofNullable(this.filter);
        }

        Optional<UInteger> queueSize() {
            return Optional.ofNullable(this.queueSize);
        }

        Optional<Boolean> discardOldest() {
            return Optional.ofNullable(this.discardOldest);
        }
    }

    public static interface DataValueListener {
        public void onDataReceived(OpcUaMonitoredItem var1, DataValue var2);
    }

    public static interface EventValueListener {
        public void onEventReceived(OpcUaMonitoredItem var1, Variant[] var2);
    }

    public static class ServerState {
        private final UInteger monitoredItemId;
        private final MonitoringMode monitoringMode;
        private final double samplingInterval;
        private final @Nullable ExtensionObject filterResult;
        private final UInteger queueSize;
        private final boolean discardOldest;

        private ServerState(UInteger monitoredItemId, MonitoringMode monitoringMode, double samplingInterval, @Nullable ExtensionObject filterResult, UInteger queueSize, boolean discardOldest) {
            this.monitoredItemId = monitoredItemId;
            this.monitoringMode = monitoringMode;
            this.samplingInterval = samplingInterval;
            this.filterResult = filterResult;
            this.queueSize = queueSize;
            this.discardOldest = discardOldest;
        }

        public UInteger getMonitoredItemId() {
            return this.monitoredItemId;
        }

        public MonitoringMode getMonitoringMode() {
            return this.monitoringMode;
        }

        public double getSamplingInterval() {
            return this.samplingInterval;
        }

        public @Nullable ExtensionObject getFilterResult() {
            return this.filterResult;
        }

        public UInteger getQueueSize() {
            return this.queueSize;
        }

        public boolean getDiscardOldest() {
            return this.discardOldest;
        }
    }
}

