/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

class ClientHandleSequence {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong clientHandle;
    private final Predicate<UInteger> handleInUse;

    ClientHandleSequence(Predicate<UInteger> handleInUse) {
        this(handleInUse, 0L);
    }

    ClientHandleSequence(Predicate<UInteger> handleInUse, long initialValue) {
        this.handleInUse = handleInUse;
        this.clientHandle = new AtomicLong(initialValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UInteger nextClientHandle() {
        this.lock.lock();
        try {
            UInteger original;
            UInteger next = original = this.getAndIncrementWithRollover();
            while (this.handleInUse.test(next)) {
                next = this.getAndIncrementWithRollover();
                if (!next.equals((Object)original)) continue;
                throw new IllegalStateException("no unused client handles");
            }
            UInteger uInteger = next;
            return uInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UInteger getAndIncrementWithRollover() {
        long current = this.clientHandle.get();
        if (current > 0xFFFFFFFFL) {
            this.clientHandle.set(0L);
        }
        return Unsigned.uint((long)this.clientHandle.getAndIncrement());
    }
}

