/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.FrameTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ThreeDCartesianCoordinatesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ThreeDFrameType;
import org.eclipse.milo.opcua.sdk.client.model.variables.ThreeDOrientationTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ThreeDCartesianCoordinates;
import org.eclipse.milo.opcua.stack.core.types.structured.ThreeDOrientation;

public class ThreeDFrameTypeNode
extends FrameTypeNode
implements ThreeDFrameType {
    public ThreeDFrameTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public ThreeDCartesianCoordinates getCartesianCoordinates() throws UaException {
        ThreeDCartesianCoordinatesTypeNode node = this.getCartesianCoordinatesNode();
        return this.cast(node.getValue().getValue().getValue(), ThreeDCartesianCoordinates.class);
    }

    @Override
    public void setCartesianCoordinates(ThreeDCartesianCoordinates value) throws UaException {
        ThreeDCartesianCoordinatesTypeNode node = this.getCartesianCoordinatesNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ThreeDCartesianCoordinates readCartesianCoordinates() throws UaException {
        try {
            return this.readCartesianCoordinatesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeCartesianCoordinates(ThreeDCartesianCoordinates value) throws UaException {
        try {
            this.writeCartesianCoordinatesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ThreeDCartesianCoordinates> readCartesianCoordinatesAsync() {
        return ((CompletableFuture)this.getCartesianCoordinatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ThreeDCartesianCoordinates.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeCartesianCoordinatesAsync(ThreeDCartesianCoordinates cartesianCoordinates) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)cartesianCoordinates);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getCartesianCoordinatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ThreeDCartesianCoordinatesTypeNode getCartesianCoordinatesNode() throws UaException {
        try {
            return this.getCartesianCoordinatesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends ThreeDCartesianCoordinatesTypeNode> getCartesianCoordinatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CartesianCoordinates", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (ThreeDCartesianCoordinatesTypeNode)node);
    }

    @Override
    public ThreeDOrientation getOrientation() throws UaException {
        ThreeDOrientationTypeNode node = this.getOrientationNode();
        return this.cast(node.getValue().getValue().getValue(), ThreeDOrientation.class);
    }

    @Override
    public void setOrientation(ThreeDOrientation value) throws UaException {
        ThreeDOrientationTypeNode node = this.getOrientationNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ThreeDOrientation readOrientation() throws UaException {
        try {
            return this.readOrientationAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeOrientation(ThreeDOrientation value) throws UaException {
        try {
            this.writeOrientationAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ThreeDOrientation> readOrientationAsync() {
        return ((CompletableFuture)this.getOrientationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ThreeDOrientation.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeOrientationAsync(ThreeDOrientation orientation) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)orientation);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getOrientationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ThreeDOrientationTypeNode getOrientationNode() throws UaException {
        try {
            return this.getOrientationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends ThreeDOrientationTypeNode> getOrientationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Orientation", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (ThreeDOrientationTypeNode)node);
    }
}

