/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.AlarmStateVariableType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AlarmStateVariableTypeNode
extends BaseDataVariableTypeNode
implements AlarmStateVariableType {
    public AlarmStateVariableTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public UShort getHighestActiveSeverity() throws UaException {
        PropertyTypeNode node = this.getHighestActiveSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighestActiveSeverity(UShort value) throws UaException {
        PropertyTypeNode node = this.getHighestActiveSeverityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readHighestActiveSeverity() throws UaException {
        try {
            return this.readHighestActiveSeverityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighestActiveSeverity(UShort value) throws UaException {
        try {
            this.writeHighestActiveSeverityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readHighestActiveSeverityAsync() {
        return ((CompletableFuture)this.getHighestActiveSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighestActiveSeverityAsync(UShort highestActiveSeverity) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highestActiveSeverity));
        return this.getHighestActiveSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighestActiveSeverityNode() throws UaException {
        try {
            return this.getHighestActiveSeverityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighestActiveSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighestActiveSeverity", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getHighestUnackSeverity() throws UaException {
        PropertyTypeNode node = this.getHighestUnackSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighestUnackSeverity(UShort value) throws UaException {
        PropertyTypeNode node = this.getHighestUnackSeverityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readHighestUnackSeverity() throws UaException {
        try {
            return this.readHighestUnackSeverityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighestUnackSeverity(UShort value) throws UaException {
        try {
            this.writeHighestUnackSeverityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readHighestUnackSeverityAsync() {
        return ((CompletableFuture)this.getHighestUnackSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighestUnackSeverityAsync(UShort highestUnackSeverity) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highestUnackSeverity));
        return this.getHighestUnackSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighestUnackSeverityNode() throws UaException {
        try {
            return this.getHighestUnackSeverityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighestUnackSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighestUnackSeverity", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getActiveCount() throws UaException {
        PropertyTypeNode node = this.getActiveCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setActiveCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getActiveCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readActiveCount() throws UaException {
        try {
            return this.readActiveCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeActiveCount(UInteger value) throws UaException {
        try {
            this.writeActiveCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readActiveCountAsync() {
        return ((CompletableFuture)this.getActiveCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActiveCountAsync(UInteger activeCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)activeCount));
        return this.getActiveCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getActiveCountNode() throws UaException {
        try {
            return this.getActiveCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getActiveCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActiveCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getUnacknowledgedCount() throws UaException {
        PropertyTypeNode node = this.getUnacknowledgedCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setUnacknowledgedCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getUnacknowledgedCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readUnacknowledgedCount() throws UaException {
        try {
            return this.readUnacknowledgedCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUnacknowledgedCount(UInteger value) throws UaException {
        try {
            this.writeUnacknowledgedCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readUnacknowledgedCountAsync() {
        return ((CompletableFuture)this.getUnacknowledgedCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUnacknowledgedCountAsync(UInteger unacknowledgedCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)unacknowledgedCount));
        return this.getUnacknowledgedCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUnacknowledgedCountNode() throws UaException {
        try {
            return this.getUnacknowledgedCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUnacknowledgedCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnacknowledgedCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getUnconfirmedCount() throws UaException {
        PropertyTypeNode node = this.getUnconfirmedCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setUnconfirmedCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getUnconfirmedCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readUnconfirmedCount() throws UaException {
        try {
            return this.readUnconfirmedCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUnconfirmedCount(UInteger value) throws UaException {
        try {
            this.writeUnconfirmedCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readUnconfirmedCountAsync() {
        return ((CompletableFuture)this.getUnconfirmedCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUnconfirmedCountAsync(UInteger unconfirmedCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)unconfirmedCount));
        return this.getUnconfirmedCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUnconfirmedCountNode() throws UaException {
        try {
            return this.getUnconfirmedCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUnconfirmedCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnconfirmedCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ContentFilter getFilter() throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        return this.cast(node.getValue().getValue().getValue(), ContentFilter.class);
    }

    @Override
    public void setFilter(ContentFilter value) throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ContentFilter readFilter() throws UaException {
        try {
            return this.readFilterAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeFilter(ContentFilter value) throws UaException {
        try {
            this.writeFilterAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ContentFilter> readFilterAsync() {
        return ((CompletableFuture)this.getFilterNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ContentFilter.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeFilterAsync(ContentFilter filter) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)filter);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getFilterNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getFilterNode() throws UaException {
        try {
            return this.getFilterNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getFilterNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Filter", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

