/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.UadpWriterGroupMessageType;
import org.eclipse.milo.opcua.sdk.client.model.objects.WriterGroupMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataSetOrderingType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.UadpNetworkMessageContentMask;

public class UadpWriterGroupMessageTypeNode
extends WriterGroupMessageTypeNode
implements UadpWriterGroupMessageType {
    public UadpWriterGroupMessageTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getGroupVersion() throws UaException {
        PropertyTypeNode node = this.getGroupVersionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setGroupVersion(UInteger value) throws UaException {
        PropertyTypeNode node = this.getGroupVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readGroupVersion() throws UaException {
        try {
            return this.readGroupVersionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeGroupVersion(UInteger value) throws UaException {
        try {
            this.writeGroupVersionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readGroupVersionAsync() {
        return ((CompletableFuture)this.getGroupVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeGroupVersionAsync(UInteger groupVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)groupVersion));
        return this.getGroupVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getGroupVersionNode() throws UaException {
        try {
            return this.getGroupVersionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getGroupVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "GroupVersion", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetOrderingType getDataSetOrdering() throws UaException {
        PropertyTypeNode node = this.getDataSetOrderingNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return DataSetOrderingType.from((int)((Integer)value));
        }
        if (value instanceof DataSetOrderingType) {
            return (DataSetOrderingType)value;
        }
        return null;
    }

    @Override
    public void setDataSetOrdering(DataSetOrderingType value) throws UaException {
        PropertyTypeNode node = this.getDataSetOrderingNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DataSetOrderingType readDataSetOrdering() throws UaException {
        try {
            return this.readDataSetOrderingAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetOrdering(DataSetOrderingType value) throws UaException {
        try {
            this.writeDataSetOrderingAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DataSetOrderingType> readDataSetOrderingAsync() {
        return ((CompletableFuture)this.getDataSetOrderingNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return DataSetOrderingType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetOrderingAsync(DataSetOrderingType dataSetOrdering) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetOrdering));
        return this.getDataSetOrderingNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetOrderingNode() throws UaException {
        try {
            return this.getDataSetOrderingNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetOrderingNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetOrdering", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        return (UadpNetworkMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UadpNetworkMessageContentMask readNetworkMessageContentMask() throws UaException {
        try {
            return this.readNetworkMessageContentMaskAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeNetworkMessageContentMask(UadpNetworkMessageContentMask value) throws UaException {
        try {
            this.writeNetworkMessageContentMaskAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UadpNetworkMessageContentMask> readNetworkMessageContentMaskAsync() {
        return ((CompletableFuture)this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UadpNetworkMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNetworkMessageContentMaskAsync(UadpNetworkMessageContentMask networkMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)networkMessageContentMask));
        return this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNetworkMessageContentMaskNode() throws UaException {
        try {
            return this.getNetworkMessageContentMaskNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNetworkMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NetworkMessageContentMask", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getSamplingOffset() throws UaException {
        PropertyTypeNode node = this.getSamplingOffsetNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setSamplingOffset(Double value) throws UaException {
        PropertyTypeNode node = this.getSamplingOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readSamplingOffset() throws UaException {
        try {
            return this.readSamplingOffsetAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSamplingOffset(Double value) throws UaException {
        try {
            this.writeSamplingOffsetAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readSamplingOffsetAsync() {
        return ((CompletableFuture)this.getSamplingOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSamplingOffsetAsync(Double samplingOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)samplingOffset));
        return this.getSamplingOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSamplingOffsetNode() throws UaException {
        try {
            return this.getSamplingOffsetNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSamplingOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SamplingOffset", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double[] getPublishingOffset() throws UaException {
        PropertyTypeNode node = this.getPublishingOffsetNode();
        return (Double[])node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingOffset(Double[] value) throws UaException {
        PropertyTypeNode node = this.getPublishingOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double[] readPublishingOffset() throws UaException {
        try {
            return this.readPublishingOffsetAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePublishingOffset(Double[] value) throws UaException {
        try {
            this.writePublishingOffsetAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double[]> readPublishingOffsetAsync() {
        return ((CompletableFuture)this.getPublishingOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingOffsetAsync(Double[] publishingOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingOffset));
        return this.getPublishingOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPublishingOffsetNode() throws UaException {
        try {
            return this.getPublishingOffsetNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPublishingOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingOffset", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

