/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.RoleType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointType;
import org.eclipse.milo.opcua.stack.core.types.structured.IdentityMappingRuleType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class RoleTypeNode
extends BaseObjectTypeNode
implements RoleType {
    public RoleTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public IdentityMappingRuleType[] getIdentities() throws UaException {
        PropertyTypeNode node = this.getIdentitiesNode();
        return this.cast(node.getValue().getValue().getValue(), IdentityMappingRuleType[].class);
    }

    @Override
    public void setIdentities(IdentityMappingRuleType[] value) throws UaException {
        PropertyTypeNode node = this.getIdentitiesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public IdentityMappingRuleType[] readIdentities() throws UaException {
        try {
            return this.readIdentitiesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeIdentities(IdentityMappingRuleType[] value) throws UaException {
        try {
            this.writeIdentitiesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends IdentityMappingRuleType[]> readIdentitiesAsync() {
        return ((CompletableFuture)this.getIdentitiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), IdentityMappingRuleType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeIdentitiesAsync(IdentityMappingRuleType[] identities) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])identities);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getIdentitiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIdentitiesNode() throws UaException {
        try {
            return this.getIdentitiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIdentitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Identities", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getApplicationsExclude() throws UaException {
        PropertyTypeNode node = this.getApplicationsExcludeNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setApplicationsExclude(Boolean value) throws UaException {
        PropertyTypeNode node = this.getApplicationsExcludeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readApplicationsExclude() throws UaException {
        try {
            return this.readApplicationsExcludeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeApplicationsExclude(Boolean value) throws UaException {
        try {
            this.writeApplicationsExcludeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readApplicationsExcludeAsync() {
        return ((CompletableFuture)this.getApplicationsExcludeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationsExcludeAsync(Boolean applicationsExclude) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationsExclude));
        return this.getApplicationsExcludeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationsExcludeNode() throws UaException {
        try {
            return this.getApplicationsExcludeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getApplicationsExcludeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationsExclude", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getApplications() throws UaException {
        PropertyTypeNode node = this.getApplicationsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setApplications(String[] value) throws UaException {
        PropertyTypeNode node = this.getApplicationsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readApplications() throws UaException {
        try {
            return this.readApplicationsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeApplications(String[] value) throws UaException {
        try {
            this.writeApplicationsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readApplicationsAsync() {
        return ((CompletableFuture)this.getApplicationsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationsAsync(String[] applications) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applications));
        return this.getApplicationsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationsNode() throws UaException {
        try {
            return this.getApplicationsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getApplicationsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Applications", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getEndpointsExclude() throws UaException {
        PropertyTypeNode node = this.getEndpointsExcludeNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setEndpointsExclude(Boolean value) throws UaException {
        PropertyTypeNode node = this.getEndpointsExcludeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readEndpointsExclude() throws UaException {
        try {
            return this.readEndpointsExcludeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEndpointsExclude(Boolean value) throws UaException {
        try {
            this.writeEndpointsExcludeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readEndpointsExcludeAsync() {
        return ((CompletableFuture)this.getEndpointsExcludeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEndpointsExcludeAsync(Boolean endpointsExclude) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)endpointsExclude));
        return this.getEndpointsExcludeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEndpointsExcludeNode() throws UaException {
        try {
            return this.getEndpointsExcludeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEndpointsExcludeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EndpointsExclude", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EndpointType[] getEndpoints() throws UaException {
        PropertyTypeNode node = this.getEndpointsNode();
        return this.cast(node.getValue().getValue().getValue(), EndpointType[].class);
    }

    @Override
    public void setEndpoints(EndpointType[] value) throws UaException {
        PropertyTypeNode node = this.getEndpointsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public EndpointType[] readEndpoints() throws UaException {
        try {
            return this.readEndpointsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEndpoints(EndpointType[] value) throws UaException {
        try {
            this.writeEndpointsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends EndpointType[]> readEndpointsAsync() {
        return ((CompletableFuture)this.getEndpointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EndpointType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeEndpointsAsync(EndpointType[] endpoints) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])endpoints);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getEndpointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEndpointsNode() throws UaException {
        try {
            return this.getEndpointsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEndpointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Endpoints", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getCustomConfiguration() throws UaException {
        PropertyTypeNode node = this.getCustomConfigurationNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setCustomConfiguration(Boolean value) throws UaException {
        PropertyTypeNode node = this.getCustomConfigurationNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readCustomConfiguration() throws UaException {
        try {
            return this.readCustomConfigurationAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeCustomConfiguration(Boolean value) throws UaException {
        try {
            this.writeCustomConfigurationAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readCustomConfigurationAsync() {
        return ((CompletableFuture)this.getCustomConfigurationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCustomConfigurationAsync(Boolean customConfiguration) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)customConfiguration));
        return this.getCustomConfigurationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCustomConfigurationNode() throws UaException {
        try {
            return this.getCustomConfigurationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCustomConfigurationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CustomConfiguration", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

