/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetFolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubCapabilitiesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubConfigurationTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsRootTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubKeyServiceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PublishSubscribeType;
import org.eclipse.milo.opcua.sdk.client.model.objects.SubscribedDataSetFolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PublishSubscribeTypeNode
extends PubSubKeyServiceTypeNode
implements PublishSubscribeType {
    public PublishSubscribeTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String[] getSupportedTransportProfiles() throws UaException {
        PropertyTypeNode node = this.getSupportedTransportProfilesNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportedTransportProfiles(String[] value) throws UaException {
        PropertyTypeNode node = this.getSupportedTransportProfilesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readSupportedTransportProfiles() throws UaException {
        try {
            return this.readSupportedTransportProfilesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSupportedTransportProfiles(String[] value) throws UaException {
        try {
            this.writeSupportedTransportProfilesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readSupportedTransportProfilesAsync() {
        return ((CompletableFuture)this.getSupportedTransportProfilesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportedTransportProfilesAsync(String[] supportedTransportProfiles) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportedTransportProfiles));
        return this.getSupportedTransportProfilesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportedTransportProfilesNode() throws UaException {
        try {
            return this.getSupportedTransportProfilesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportedTransportProfilesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportedTransportProfiles", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ULong getDefaultDatagramPublisherId() throws UaException {
        PropertyTypeNode node = this.getDefaultDatagramPublisherIdNode();
        return (ULong)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefaultDatagramPublisherId(ULong value) throws UaException {
        PropertyTypeNode node = this.getDefaultDatagramPublisherIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ULong readDefaultDatagramPublisherId() throws UaException {
        try {
            return this.readDefaultDatagramPublisherIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDefaultDatagramPublisherId(ULong value) throws UaException {
        try {
            this.writeDefaultDatagramPublisherIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ULong> readDefaultDatagramPublisherIdAsync() {
        return ((CompletableFuture)this.getDefaultDatagramPublisherIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ULong)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultDatagramPublisherIdAsync(ULong defaultDatagramPublisherId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)defaultDatagramPublisherId));
        return this.getDefaultDatagramPublisherIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultDatagramPublisherIdNode() throws UaException {
        try {
            return this.getDefaultDatagramPublisherIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultDatagramPublisherIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultDatagramPublisherId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getConfigurationVersion() throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setConfigurationVersion(UInteger value) throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readConfigurationVersion() throws UaException {
        try {
            return this.readConfigurationVersionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConfigurationVersion(UInteger value) throws UaException {
        try {
            this.writeConfigurationVersionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readConfigurationVersionAsync() {
        return ((CompletableFuture)this.getConfigurationVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConfigurationVersionAsync(UInteger configurationVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)configurationVersion));
        return this.getConfigurationVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConfigurationVersionNode() throws UaException {
        try {
            return this.getConfigurationVersionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConfigurationVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfigurationVersion", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EndpointDescription[] getDefaultSecurityKeyServices() throws UaException {
        PropertyTypeNode node = this.getDefaultSecurityKeyServicesNode();
        return this.cast(node.getValue().getValue().getValue(), EndpointDescription[].class);
    }

    @Override
    public void setDefaultSecurityKeyServices(EndpointDescription[] value) throws UaException {
        PropertyTypeNode node = this.getDefaultSecurityKeyServicesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public EndpointDescription[] readDefaultSecurityKeyServices() throws UaException {
        try {
            return this.readDefaultSecurityKeyServicesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDefaultSecurityKeyServices(EndpointDescription[] value) throws UaException {
        try {
            this.writeDefaultSecurityKeyServicesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends EndpointDescription[]> readDefaultSecurityKeyServicesAsync() {
        return ((CompletableFuture)this.getDefaultSecurityKeyServicesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EndpointDescription[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultSecurityKeyServicesAsync(EndpointDescription[] defaultSecurityKeyServices) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])defaultSecurityKeyServices);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDefaultSecurityKeyServicesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultSecurityKeyServicesNode() throws UaException {
        try {
            return this.getDefaultSecurityKeyServicesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultSecurityKeyServicesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultSecurityKeyServices", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public KeyValuePair[] getConfigurationProperties() throws UaException {
        PropertyTypeNode node = this.getConfigurationPropertiesNode();
        return this.cast(node.getValue().getValue().getValue(), KeyValuePair[].class);
    }

    @Override
    public void setConfigurationProperties(KeyValuePair[] value) throws UaException {
        PropertyTypeNode node = this.getConfigurationPropertiesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public KeyValuePair[] readConfigurationProperties() throws UaException {
        try {
            return this.readConfigurationPropertiesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConfigurationProperties(KeyValuePair[] value) throws UaException {
        try {
            this.writeConfigurationPropertiesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends KeyValuePair[]> readConfigurationPropertiesAsync() {
        return ((CompletableFuture)this.getConfigurationPropertiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), KeyValuePair[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeConfigurationPropertiesAsync(KeyValuePair[] configurationProperties) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])configurationProperties);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getConfigurationPropertiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConfigurationPropertiesNode() throws UaException {
        try {
            return this.getConfigurationPropertiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConfigurationPropertiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfigurationProperties", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetFolderTypeNode getPublishedDataSetsNode() throws UaException {
        try {
            return this.getPublishedDataSetsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends DataSetFolderTypeNode> getPublishedDataSetsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishedDataSets", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (DataSetFolderTypeNode)node);
    }

    @Override
    public SubscribedDataSetFolderTypeNode getSubscribedDataSetsNode() throws UaException {
        try {
            return this.getSubscribedDataSetsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends SubscribedDataSetFolderTypeNode> getSubscribedDataSetsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SubscribedDataSets", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (SubscribedDataSetFolderTypeNode)node);
    }

    @Override
    public PubSubConfigurationTypeNode getPubSubConfigurationNode() throws UaException {
        try {
            return this.getPubSubConfigurationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubConfigurationTypeNode> getPubSubConfigurationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PubSubConfiguration", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubConfigurationTypeNode)node);
    }

    @Override
    public PubSubStatusTypeNode getStatusNode() throws UaException {
        try {
            return this.getStatusNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubStatusTypeNode> getStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Status", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubStatusTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsRootTypeNode getDiagnosticsNode() throws UaException {
        try {
            return this.getDiagnosticsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsRootTypeNode> getDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Diagnostics", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsRootTypeNode)node);
    }

    @Override
    public PubSubCapabilitiesTypeNode getPubSubCapablitiesNode() throws UaException {
        try {
            return this.getPubSubCapablitiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubCapabilitiesTypeNode> getPubSubCapablitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PubSubCapablities", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubCapabilitiesTypeNode)node);
    }

    @Override
    public FolderTypeNode getDataSetClassesNode() throws UaException {
        try {
            return this.getDataSetClassesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getDataSetClassesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetClasses", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

