/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.client.model.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ProgramDiagnostic2TypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnostic2DataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ProgramStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    public ProgramStateMachineTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Boolean getCreatable() throws UaException {
        PropertyTypeNode node = this.getCreatableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setCreatable(Boolean value) throws UaException {
        PropertyTypeNode node = this.getCreatableNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readCreatable() throws UaException {
        try {
            return this.readCreatableAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeCreatable(Boolean value) throws UaException {
        try {
            this.writeCreatableAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readCreatableAsync() {
        return ((CompletableFuture)this.getCreatableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCreatableAsync(Boolean creatable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)creatable));
        return this.getCreatableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCreatableNode() throws UaException {
        try {
            return this.getCreatableNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCreatableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Creatable", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeletable() throws UaException {
        PropertyTypeNode node = this.getDeletableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeletable(Boolean value) throws UaException {
        PropertyTypeNode node = this.getDeletableNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readDeletable() throws UaException {
        try {
            return this.readDeletableAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDeletable(Boolean value) throws UaException {
        try {
            this.writeDeletableAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeletableAsync() {
        return ((CompletableFuture)this.getDeletableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDeletableAsync(Boolean deletable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deletable));
        return this.getDeletableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDeletableNode() throws UaException {
        try {
            return this.getDeletableNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeletableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Deletable", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAutoDelete() throws UaException {
        PropertyTypeNode node = this.getAutoDeleteNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAutoDelete(Boolean value) throws UaException {
        PropertyTypeNode node = this.getAutoDeleteNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readAutoDelete() throws UaException {
        try {
            return this.readAutoDeleteAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeAutoDelete(Boolean value) throws UaException {
        try {
            this.writeAutoDeleteAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAutoDeleteAsync() {
        return ((CompletableFuture)this.getAutoDeleteNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAutoDeleteAsync(Boolean autoDelete) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)autoDelete));
        return this.getAutoDeleteNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAutoDeleteNode() throws UaException {
        try {
            return this.getAutoDeleteNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAutoDeleteNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AutoDelete", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getRecycleCount() throws UaException {
        PropertyTypeNode node = this.getRecycleCountNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setRecycleCount(Integer value) throws UaException {
        PropertyTypeNode node = this.getRecycleCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Integer readRecycleCount() throws UaException {
        try {
            return this.readRecycleCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeRecycleCount(Integer value) throws UaException {
        try {
            this.writeRecycleCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readRecycleCountAsync() {
        return ((CompletableFuture)this.getRecycleCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRecycleCountAsync(Integer recycleCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)recycleCount));
        return this.getRecycleCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRecycleCountNode() throws UaException {
        try {
            return this.getRecycleCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRecycleCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RecycleCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getInstanceCount() throws UaException {
        PropertyTypeNode node = this.getInstanceCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setInstanceCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getInstanceCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readInstanceCount() throws UaException {
        try {
            return this.readInstanceCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeInstanceCount(UInteger value) throws UaException {
        try {
            this.writeInstanceCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readInstanceCountAsync() {
        return ((CompletableFuture)this.getInstanceCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInstanceCountAsync(UInteger instanceCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)instanceCount));
        return this.getInstanceCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInstanceCountNode() throws UaException {
        try {
            return this.getInstanceCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInstanceCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InstanceCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxInstanceCount() throws UaException {
        PropertyTypeNode node = this.getMaxInstanceCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxInstanceCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxInstanceCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxInstanceCount() throws UaException {
        try {
            return this.readMaxInstanceCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxInstanceCount(UInteger value) throws UaException {
        try {
            this.writeMaxInstanceCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxInstanceCountAsync() {
        return ((CompletableFuture)this.getMaxInstanceCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxInstanceCountAsync(UInteger maxInstanceCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxInstanceCount));
        return this.getMaxInstanceCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxInstanceCountNode() throws UaException {
        try {
            return this.getMaxInstanceCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxInstanceCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxInstanceCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxRecycleCount() throws UaException {
        PropertyTypeNode node = this.getMaxRecycleCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxRecycleCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxRecycleCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxRecycleCount() throws UaException {
        try {
            return this.readMaxRecycleCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxRecycleCount(UInteger value) throws UaException {
        try {
            this.writeMaxRecycleCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxRecycleCountAsync() {
        return ((CompletableFuture)this.getMaxRecycleCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxRecycleCountAsync(UInteger maxRecycleCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxRecycleCount));
        return this.getMaxRecycleCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxRecycleCountNode() throws UaException {
        try {
            return this.getMaxRecycleCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxRecycleCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxRecycleCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getCurrentState() throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentState(LocalizedText value) throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readCurrentState() throws UaException {
        try {
            return this.readCurrentStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeCurrentState(LocalizedText value) throws UaException {
        try {
            this.writeCurrentStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCurrentStateAsync() {
        return ((CompletableFuture)this.getCurrentStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentStateAsync(LocalizedText currentState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentState));
        return this.getCurrentStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public FiniteStateVariableTypeNode getCurrentStateNode() throws UaException {
        try {
            return this.getCurrentStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends FiniteStateVariableTypeNode> getCurrentStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FiniteStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLastTransition() throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastTransition(LocalizedText value) throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readLastTransition() throws UaException {
        try {
            return this.readLastTransitionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLastTransition(LocalizedText value) throws UaException {
        try {
            this.writeLastTransitionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLastTransitionAsync() {
        return ((CompletableFuture)this.getLastTransitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastTransitionAsync(LocalizedText lastTransition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastTransition));
        return this.getLastTransitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public FiniteTransitionVariableTypeNode getLastTransitionNode() throws UaException {
        try {
            return this.getLastTransitionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends FiniteTransitionVariableTypeNode> getLastTransitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastTransition", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FiniteTransitionVariableTypeNode)node);
    }

    @Override
    public ProgramDiagnostic2DataType getProgramDiagnostic() throws UaException {
        ProgramDiagnostic2TypeNode node = this.getProgramDiagnosticNode();
        return this.cast(node.getValue().getValue().getValue(), ProgramDiagnostic2DataType.class);
    }

    @Override
    public void setProgramDiagnostic(ProgramDiagnostic2DataType value) throws UaException {
        ProgramDiagnostic2TypeNode node = this.getProgramDiagnosticNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ProgramDiagnostic2DataType readProgramDiagnostic() throws UaException {
        try {
            return this.readProgramDiagnosticAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeProgramDiagnostic(ProgramDiagnostic2DataType value) throws UaException {
        try {
            this.writeProgramDiagnosticAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ProgramDiagnostic2DataType> readProgramDiagnosticAsync() {
        return ((CompletableFuture)this.getProgramDiagnosticNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ProgramDiagnostic2DataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeProgramDiagnosticAsync(ProgramDiagnostic2DataType programDiagnostic) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)programDiagnostic);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getProgramDiagnosticNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ProgramDiagnostic2TypeNode getProgramDiagnosticNode() throws UaException {
        try {
            return this.getProgramDiagnosticNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends ProgramDiagnostic2TypeNode> getProgramDiagnosticNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProgramDiagnostic", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (ProgramDiagnostic2TypeNode)node);
    }

    @Override
    public BaseObjectTypeNode getFinalResultDataNode() throws UaException {
        try {
            return this.getFinalResultDataNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseObjectTypeNode> getFinalResultDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FinalResultData", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseObjectTypeNode)node);
    }

    @Override
    public StateTypeNode getHaltedNode() throws UaException {
        try {
            return this.getHaltedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends StateTypeNode> getHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Halted", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getReadyNode() throws UaException {
        try {
            return this.getReadyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends StateTypeNode> getReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Ready", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getRunningNode() throws UaException {
        try {
            return this.getRunningNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends StateTypeNode> getRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Running", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getSuspendedNode() throws UaException {
        try {
            return this.getSuspendedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends StateTypeNode> getSuspendedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Suspended", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public TransitionTypeNode getHaltedToReadyNode() throws UaException {
        try {
            return this.getHaltedToReadyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getHaltedToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HaltedToReady", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getReadyToRunningNode() throws UaException {
        try {
            return this.getReadyToRunningNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getReadyToRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReadyToRunning", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToHaltedNode() throws UaException {
        try {
            return this.getRunningToHaltedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToHalted", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToReadyNode() throws UaException {
        try {
            return this.getRunningToReadyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToReady", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToSuspendedNode() throws UaException {
        try {
            return this.getRunningToSuspendedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToSuspendedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToSuspended", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToRunningNode() throws UaException {
        try {
            return this.getSuspendedToRunningNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToRunning", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToHaltedNode() throws UaException {
        try {
            return this.getSuspendedToHaltedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToHalted", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToReadyNode() throws UaException {
        try {
            return this.getSuspendedToReadyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToReady", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getReadyToHaltedNode() throws UaException {
        try {
            return this.getReadyToHaltedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getReadyToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReadyToHalted", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }
}

