/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.OperationLimitsType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class OperationLimitsTypeNode
extends FolderTypeNode
implements OperationLimitsType {
    public OperationLimitsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getMaxNodesPerRead() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerReadNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerRead(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerReadNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerRead() throws UaException {
        try {
            return this.readMaxNodesPerReadAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerRead(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerReadAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerReadAsync() {
        return ((CompletableFuture)this.getMaxNodesPerReadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerReadAsync(UInteger maxNodesPerRead) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerRead));
        return this.getMaxNodesPerReadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerReadNode() throws UaException {
        try {
            return this.getMaxNodesPerReadNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerReadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerRead", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryReadData() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadDataNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryReadData(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadDataNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerHistoryReadData() throws UaException {
        try {
            return this.readMaxNodesPerHistoryReadDataAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerHistoryReadData(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerHistoryReadDataAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryReadDataAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryReadDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryReadDataAsync(UInteger maxNodesPerHistoryReadData) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerHistoryReadData));
        return this.getMaxNodesPerHistoryReadDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryReadDataNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryReadDataNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryReadDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryReadData", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryReadEvents() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadEventsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryReadEvents(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadEventsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerHistoryReadEvents() throws UaException {
        try {
            return this.readMaxNodesPerHistoryReadEventsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerHistoryReadEvents(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerHistoryReadEventsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryReadEventsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryReadEventsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryReadEventsAsync(UInteger maxNodesPerHistoryReadEvents) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerHistoryReadEvents));
        return this.getMaxNodesPerHistoryReadEventsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryReadEventsNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryReadEventsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryReadEventsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryReadEvents", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerWrite() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerWriteNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerWrite(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerWriteNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerWrite() throws UaException {
        try {
            return this.readMaxNodesPerWriteAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerWrite(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerWriteAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerWriteAsync() {
        return ((CompletableFuture)this.getMaxNodesPerWriteNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerWriteAsync(UInteger maxNodesPerWrite) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerWrite));
        return this.getMaxNodesPerWriteNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerWriteNode() throws UaException {
        try {
            return this.getMaxNodesPerWriteNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerWriteNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerWrite", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryUpdateData() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateDataNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryUpdateData(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateDataNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerHistoryUpdateData() throws UaException {
        try {
            return this.readMaxNodesPerHistoryUpdateDataAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerHistoryUpdateData(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerHistoryUpdateDataAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryUpdateDataAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryUpdateDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryUpdateDataAsync(UInteger maxNodesPerHistoryUpdateData) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerHistoryUpdateData));
        return this.getMaxNodesPerHistoryUpdateDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryUpdateDataNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryUpdateDataNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryUpdateDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryUpdateData", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryUpdateEvents() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateEventsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryUpdateEvents(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateEventsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerHistoryUpdateEvents() throws UaException {
        try {
            return this.readMaxNodesPerHistoryUpdateEventsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerHistoryUpdateEvents(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerHistoryUpdateEventsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryUpdateEventsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryUpdateEventsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryUpdateEventsAsync(UInteger maxNodesPerHistoryUpdateEvents) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerHistoryUpdateEvents));
        return this.getMaxNodesPerHistoryUpdateEventsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryUpdateEventsNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryUpdateEventsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryUpdateEventsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryUpdateEvents", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerMethodCall() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerMethodCallNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerMethodCall(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerMethodCallNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerMethodCall() throws UaException {
        try {
            return this.readMaxNodesPerMethodCallAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerMethodCall(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerMethodCallAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerMethodCallAsync() {
        return ((CompletableFuture)this.getMaxNodesPerMethodCallNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerMethodCallAsync(UInteger maxNodesPerMethodCall) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerMethodCall));
        return this.getMaxNodesPerMethodCallNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerMethodCallNode() throws UaException {
        try {
            return this.getMaxNodesPerMethodCallNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerMethodCallNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerMethodCall", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerBrowse() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerBrowseNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerBrowse(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerBrowseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerBrowse() throws UaException {
        try {
            return this.readMaxNodesPerBrowseAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerBrowse(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerBrowseAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerBrowseAsync() {
        return ((CompletableFuture)this.getMaxNodesPerBrowseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerBrowseAsync(UInteger maxNodesPerBrowse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerBrowse));
        return this.getMaxNodesPerBrowseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerBrowseNode() throws UaException {
        try {
            return this.getMaxNodesPerBrowseNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerBrowseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerBrowse", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerRegisterNodes() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerRegisterNodesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerRegisterNodes(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerRegisterNodesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerRegisterNodes() throws UaException {
        try {
            return this.readMaxNodesPerRegisterNodesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerRegisterNodes(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerRegisterNodesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerRegisterNodesAsync() {
        return ((CompletableFuture)this.getMaxNodesPerRegisterNodesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerRegisterNodesAsync(UInteger maxNodesPerRegisterNodes) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerRegisterNodes));
        return this.getMaxNodesPerRegisterNodesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerRegisterNodesNode() throws UaException {
        try {
            return this.getMaxNodesPerRegisterNodesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerRegisterNodesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerRegisterNodes", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerTranslateBrowsePathsToNodeIds() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerTranslateBrowsePathsToNodeIds(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerTranslateBrowsePathsToNodeIds() throws UaException {
        try {
            return this.readMaxNodesPerTranslateBrowsePathsToNodeIdsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerTranslateBrowsePathsToNodeIds(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerTranslateBrowsePathsToNodeIdsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerTranslateBrowsePathsToNodeIdsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerTranslateBrowsePathsToNodeIdsAsync(UInteger maxNodesPerTranslateBrowsePathsToNodeIds) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerTranslateBrowsePathsToNodeIds));
        return this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerTranslateBrowsePathsToNodeIdsNode() throws UaException {
        try {
            return this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerTranslateBrowsePathsToNodeIds", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerNodeManagement() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerNodeManagementNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerNodeManagement(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerNodeManagementNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNodesPerNodeManagement() throws UaException {
        try {
            return this.readMaxNodesPerNodeManagementAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxNodesPerNodeManagement(UInteger value) throws UaException {
        try {
            this.writeMaxNodesPerNodeManagementAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerNodeManagementAsync() {
        return ((CompletableFuture)this.getMaxNodesPerNodeManagementNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerNodeManagementAsync(UInteger maxNodesPerNodeManagement) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNodesPerNodeManagement));
        return this.getMaxNodesPerNodeManagementNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerNodeManagementNode() throws UaException {
        try {
            return this.getMaxNodesPerNodeManagementNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerNodeManagementNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerNodeManagement", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxMonitoredItemsPerCall() throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerCallNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxMonitoredItemsPerCall(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerCallNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxMonitoredItemsPerCall() throws UaException {
        try {
            return this.readMaxMonitoredItemsPerCallAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxMonitoredItemsPerCall(UInteger value) throws UaException {
        try {
            this.writeMaxMonitoredItemsPerCallAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxMonitoredItemsPerCallAsync() {
        return ((CompletableFuture)this.getMaxMonitoredItemsPerCallNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxMonitoredItemsPerCallAsync(UInteger maxMonitoredItemsPerCall) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxMonitoredItemsPerCall));
        return this.getMaxMonitoredItemsPerCallNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxMonitoredItemsPerCallNode() throws UaException {
        try {
            return this.getMaxMonitoredItemsPerCallNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxMonitoredItemsPerCallNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxMonitoredItemsPerCall", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

