/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.LimitAlarmTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.NonExclusiveLimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class NonExclusiveLimitAlarmTypeNode
extends LimitAlarmTypeNode
implements NonExclusiveLimitAlarmType {
    public NonExclusiveLimitAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LocalizedText getActiveState() throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setActiveState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readActiveState() throws UaException {
        try {
            return this.readActiveStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeActiveState(LocalizedText value) throws UaException {
        try {
            this.writeActiveStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readActiveStateAsync() {
        return ((CompletableFuture)this.getActiveStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActiveStateAsync(LocalizedText activeState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)activeState));
        return this.getActiveStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getActiveStateNode() throws UaException {
        try {
            return this.getActiveStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getActiveStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActiveState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getHighHighState() throws UaException {
        TwoStateVariableTypeNode node = this.getHighHighStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighHighState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getHighHighStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readHighHighState() throws UaException {
        try {
            return this.readHighHighStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighHighState(LocalizedText value) throws UaException {
        try {
            this.writeHighHighStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readHighHighStateAsync() {
        return ((CompletableFuture)this.getHighHighStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighHighStateAsync(LocalizedText highHighState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highHighState));
        return this.getHighHighStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getHighHighStateNode() throws UaException {
        try {
            return this.getHighHighStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getHighHighStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighHighState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getHighState() throws UaException {
        TwoStateVariableTypeNode node = this.getHighStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getHighStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readHighState() throws UaException {
        try {
            return this.readHighStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighState(LocalizedText value) throws UaException {
        try {
            this.writeHighStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readHighStateAsync() {
        return ((CompletableFuture)this.getHighStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighStateAsync(LocalizedText highState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highState));
        return this.getHighStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getHighStateNode() throws UaException {
        try {
            return this.getHighStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getHighStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLowState() throws UaException {
        TwoStateVariableTypeNode node = this.getLowStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getLowStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readLowState() throws UaException {
        try {
            return this.readLowStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowState(LocalizedText value) throws UaException {
        try {
            this.writeLowStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLowStateAsync() {
        return ((CompletableFuture)this.getLowStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowStateAsync(LocalizedText lowState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowState));
        return this.getLowStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getLowStateNode() throws UaException {
        try {
            return this.getLowStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getLowStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLowLowState() throws UaException {
        TwoStateVariableTypeNode node = this.getLowLowStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLowState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getLowLowStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readLowLowState() throws UaException {
        try {
            return this.readLowLowStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowLowState(LocalizedText value) throws UaException {
        try {
            this.writeLowLowStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLowLowStateAsync() {
        return ((CompletableFuture)this.getLowLowStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLowStateAsync(LocalizedText lowLowState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLowState));
        return this.getLowLowStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getLowLowStateNode() throws UaException {
        try {
            return this.getLowLowStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getLowLowStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLowState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }
}

