/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.JsonDataSetReaderMessageType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.JsonDataSetMessageContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.JsonNetworkMessageContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class JsonDataSetReaderMessageTypeNode
extends DataSetReaderMessageTypeNode
implements JsonDataSetReaderMessageType {
    public JsonDataSetReaderMessageTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public JsonNetworkMessageContentMask getNetworkMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        return (JsonNetworkMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setNetworkMessageContentMask(JsonNetworkMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public JsonNetworkMessageContentMask readNetworkMessageContentMask() throws UaException {
        try {
            return this.readNetworkMessageContentMaskAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeNetworkMessageContentMask(JsonNetworkMessageContentMask value) throws UaException {
        try {
            this.writeNetworkMessageContentMaskAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends JsonNetworkMessageContentMask> readNetworkMessageContentMaskAsync() {
        return ((CompletableFuture)this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (JsonNetworkMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNetworkMessageContentMaskAsync(JsonNetworkMessageContentMask networkMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)networkMessageContentMask));
        return this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNetworkMessageContentMaskNode() throws UaException {
        try {
            return this.getNetworkMessageContentMaskNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNetworkMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NetworkMessageContentMask", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public JsonDataSetMessageContentMask getDataSetMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        return (JsonDataSetMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetMessageContentMask(JsonDataSetMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public JsonDataSetMessageContentMask readDataSetMessageContentMask() throws UaException {
        try {
            return this.readDataSetMessageContentMaskAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetMessageContentMask(JsonDataSetMessageContentMask value) throws UaException {
        try {
            this.writeDataSetMessageContentMaskAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends JsonDataSetMessageContentMask> readDataSetMessageContentMaskAsync() {
        return ((CompletableFuture)this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (JsonDataSetMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetMessageContentMaskAsync(JsonDataSetMessageContentMask dataSetMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetMessageContentMask));
        return this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetMessageContentMaskNode() throws UaException {
        try {
            return this.getDataSetMessageContentMaskNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetMessageContentMask", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

