/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IIeeeTsnMacAddressType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IIeeeTsnMacAddressTypeNode
extends BaseInterfaceTypeNode
implements IIeeeTsnMacAddressType {
    public IIeeeTsnMacAddressTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UByte[] getDestinationAddress() throws UaException {
        BaseDataVariableTypeNode node = this.getDestinationAddressNode();
        return (UByte[])node.getValue().getValue().getValue();
    }

    @Override
    public void setDestinationAddress(UByte[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getDestinationAddressNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte[] readDestinationAddress() throws UaException {
        try {
            return this.readDestinationAddressAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDestinationAddress(UByte[] value) throws UaException {
        try {
            this.writeDestinationAddressAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UByte[]> readDestinationAddressAsync() {
        return ((CompletableFuture)this.getDestinationAddressNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDestinationAddressAsync(UByte[] destinationAddress) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)destinationAddress));
        return this.getDestinationAddressNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDestinationAddressNode() throws UaException {
        try {
            return this.getDestinationAddressNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDestinationAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DestinationAddress", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UByte[] getSourceAddress() throws UaException {
        BaseDataVariableTypeNode node = this.getSourceAddressNode();
        return (UByte[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSourceAddress(UByte[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getSourceAddressNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte[] readSourceAddress() throws UaException {
        try {
            return this.readSourceAddressAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSourceAddress(UByte[] value) throws UaException {
        try {
            this.writeSourceAddressAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UByte[]> readSourceAddressAsync() {
        return ((CompletableFuture)this.getSourceAddressNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSourceAddressAsync(UByte[] sourceAddress) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sourceAddress));
        return this.getSourceAddressNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSourceAddressNode() throws UaException {
        try {
            return this.getSourceAddressNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSourceAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SourceAddress", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

