/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IIeeeAutoNegotiationStatusType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NegotiationStatus;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IIeeeAutoNegotiationStatusTypeNode
extends BaseInterfaceTypeNode
implements IIeeeAutoNegotiationStatusType {
    public IIeeeAutoNegotiationStatusTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NegotiationStatus getNegotiationStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getNegotiationStatusNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return NegotiationStatus.from((int)((Integer)value));
        }
        if (value instanceof NegotiationStatus) {
            return (NegotiationStatus)value;
        }
        return null;
    }

    @Override
    public void setNegotiationStatus(NegotiationStatus value) throws UaException {
        BaseDataVariableTypeNode node = this.getNegotiationStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NegotiationStatus readNegotiationStatus() throws UaException {
        try {
            return this.readNegotiationStatusAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeNegotiationStatus(NegotiationStatus value) throws UaException {
        try {
            this.writeNegotiationStatusAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NegotiationStatus> readNegotiationStatusAsync() {
        return ((CompletableFuture)this.getNegotiationStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return NegotiationStatus.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeNegotiationStatusAsync(NegotiationStatus negotiationStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)negotiationStatus));
        return this.getNegotiationStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getNegotiationStatusNode() throws UaException {
        try {
            return this.getNegotiationStatusNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getNegotiationStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NegotiationStatus", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

