/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.HistoryServerCapabilitiesType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class HistoryServerCapabilitiesTypeNode
extends BaseObjectTypeNode
implements HistoryServerCapabilitiesType {
    public HistoryServerCapabilitiesTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Boolean getAccessHistoryDataCapability() throws UaException {
        PropertyTypeNode node = this.getAccessHistoryDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAccessHistoryDataCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getAccessHistoryDataCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readAccessHistoryDataCapability() throws UaException {
        try {
            return this.readAccessHistoryDataCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeAccessHistoryDataCapability(Boolean value) throws UaException {
        try {
            this.writeAccessHistoryDataCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAccessHistoryDataCapabilityAsync() {
        return ((CompletableFuture)this.getAccessHistoryDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAccessHistoryDataCapabilityAsync(Boolean accessHistoryDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accessHistoryDataCapability));
        return this.getAccessHistoryDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAccessHistoryDataCapabilityNode() throws UaException {
        try {
            return this.getAccessHistoryDataCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAccessHistoryDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AccessHistoryDataCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAccessHistoryEventsCapability() throws UaException {
        PropertyTypeNode node = this.getAccessHistoryEventsCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAccessHistoryEventsCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getAccessHistoryEventsCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readAccessHistoryEventsCapability() throws UaException {
        try {
            return this.readAccessHistoryEventsCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeAccessHistoryEventsCapability(Boolean value) throws UaException {
        try {
            this.writeAccessHistoryEventsCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAccessHistoryEventsCapabilityAsync() {
        return ((CompletableFuture)this.getAccessHistoryEventsCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAccessHistoryEventsCapabilityAsync(Boolean accessHistoryEventsCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accessHistoryEventsCapability));
        return this.getAccessHistoryEventsCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAccessHistoryEventsCapabilityNode() throws UaException {
        try {
            return this.getAccessHistoryEventsCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAccessHistoryEventsCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AccessHistoryEventsCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxReturnDataValues() throws UaException {
        PropertyTypeNode node = this.getMaxReturnDataValuesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxReturnDataValues(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxReturnDataValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxReturnDataValues() throws UaException {
        try {
            return this.readMaxReturnDataValuesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxReturnDataValues(UInteger value) throws UaException {
        try {
            this.writeMaxReturnDataValuesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxReturnDataValuesAsync() {
        return ((CompletableFuture)this.getMaxReturnDataValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxReturnDataValuesAsync(UInteger maxReturnDataValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxReturnDataValues));
        return this.getMaxReturnDataValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxReturnDataValuesNode() throws UaException {
        try {
            return this.getMaxReturnDataValuesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxReturnDataValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxReturnDataValues", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxReturnEventValues() throws UaException {
        PropertyTypeNode node = this.getMaxReturnEventValuesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxReturnEventValues(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxReturnEventValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxReturnEventValues() throws UaException {
        try {
            return this.readMaxReturnEventValuesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxReturnEventValues(UInteger value) throws UaException {
        try {
            this.writeMaxReturnEventValuesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxReturnEventValuesAsync() {
        return ((CompletableFuture)this.getMaxReturnEventValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxReturnEventValuesAsync(UInteger maxReturnEventValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxReturnEventValues));
        return this.getMaxReturnEventValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxReturnEventValuesNode() throws UaException {
        try {
            return this.getMaxReturnEventValuesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxReturnEventValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxReturnEventValues", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertDataCapability() throws UaException {
        PropertyTypeNode node = this.getInsertDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertDataCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getInsertDataCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readInsertDataCapability() throws UaException {
        try {
            return this.readInsertDataCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeInsertDataCapability(Boolean value) throws UaException {
        try {
            this.writeInsertDataCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertDataCapabilityAsync() {
        return ((CompletableFuture)this.getInsertDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInsertDataCapabilityAsync(Boolean insertDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertDataCapability));
        return this.getInsertDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInsertDataCapabilityNode() throws UaException {
        try {
            return this.getInsertDataCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertDataCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getReplaceDataCapability() throws UaException {
        PropertyTypeNode node = this.getReplaceDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setReplaceDataCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getReplaceDataCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readReplaceDataCapability() throws UaException {
        try {
            return this.readReplaceDataCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeReplaceDataCapability(Boolean value) throws UaException {
        try {
            this.writeReplaceDataCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readReplaceDataCapabilityAsync() {
        return ((CompletableFuture)this.getReplaceDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReplaceDataCapabilityAsync(Boolean replaceDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)replaceDataCapability));
        return this.getReplaceDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getReplaceDataCapabilityNode() throws UaException {
        try {
            return this.getReplaceDataCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReplaceDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReplaceDataCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUpdateDataCapability() throws UaException {
        PropertyTypeNode node = this.getUpdateDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdateDataCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getUpdateDataCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readUpdateDataCapability() throws UaException {
        try {
            return this.readUpdateDataCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUpdateDataCapability(Boolean value) throws UaException {
        try {
            this.writeUpdateDataCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUpdateDataCapabilityAsync() {
        return ((CompletableFuture)this.getUpdateDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUpdateDataCapabilityAsync(Boolean updateDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updateDataCapability));
        return this.getUpdateDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUpdateDataCapabilityNode() throws UaException {
        try {
            return this.getUpdateDataCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdateDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdateDataCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteRawCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteRawCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteRawCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getDeleteRawCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readDeleteRawCapability() throws UaException {
        try {
            return this.readDeleteRawCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDeleteRawCapability(Boolean value) throws UaException {
        try {
            this.writeDeleteRawCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteRawCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteRawCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteRawCapabilityAsync(Boolean deleteRawCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteRawCapability));
        return this.getDeleteRawCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDeleteRawCapabilityNode() throws UaException {
        try {
            return this.getDeleteRawCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteRawCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteRawCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteAtTimeCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteAtTimeCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteAtTimeCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getDeleteAtTimeCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readDeleteAtTimeCapability() throws UaException {
        try {
            return this.readDeleteAtTimeCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDeleteAtTimeCapability(Boolean value) throws UaException {
        try {
            this.writeDeleteAtTimeCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteAtTimeCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteAtTimeCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteAtTimeCapabilityAsync(Boolean deleteAtTimeCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteAtTimeCapability));
        return this.getDeleteAtTimeCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDeleteAtTimeCapabilityNode() throws UaException {
        try {
            return this.getDeleteAtTimeCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteAtTimeCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteAtTimeCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertEventCapability() throws UaException {
        PropertyTypeNode node = this.getInsertEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertEventCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getInsertEventCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readInsertEventCapability() throws UaException {
        try {
            return this.readInsertEventCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeInsertEventCapability(Boolean value) throws UaException {
        try {
            this.writeInsertEventCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertEventCapabilityAsync() {
        return ((CompletableFuture)this.getInsertEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInsertEventCapabilityAsync(Boolean insertEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertEventCapability));
        return this.getInsertEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInsertEventCapabilityNode() throws UaException {
        try {
            return this.getInsertEventCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertEventCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getReplaceEventCapability() throws UaException {
        PropertyTypeNode node = this.getReplaceEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setReplaceEventCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getReplaceEventCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readReplaceEventCapability() throws UaException {
        try {
            return this.readReplaceEventCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeReplaceEventCapability(Boolean value) throws UaException {
        try {
            this.writeReplaceEventCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readReplaceEventCapabilityAsync() {
        return ((CompletableFuture)this.getReplaceEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReplaceEventCapabilityAsync(Boolean replaceEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)replaceEventCapability));
        return this.getReplaceEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getReplaceEventCapabilityNode() throws UaException {
        try {
            return this.getReplaceEventCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReplaceEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReplaceEventCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUpdateEventCapability() throws UaException {
        PropertyTypeNode node = this.getUpdateEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdateEventCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getUpdateEventCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readUpdateEventCapability() throws UaException {
        try {
            return this.readUpdateEventCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUpdateEventCapability(Boolean value) throws UaException {
        try {
            this.writeUpdateEventCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUpdateEventCapabilityAsync() {
        return ((CompletableFuture)this.getUpdateEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUpdateEventCapabilityAsync(Boolean updateEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updateEventCapability));
        return this.getUpdateEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUpdateEventCapabilityNode() throws UaException {
        try {
            return this.getUpdateEventCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdateEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdateEventCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteEventCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteEventCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getDeleteEventCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readDeleteEventCapability() throws UaException {
        try {
            return this.readDeleteEventCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDeleteEventCapability(Boolean value) throws UaException {
        try {
            this.writeDeleteEventCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteEventCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteEventCapabilityAsync(Boolean deleteEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteEventCapability));
        return this.getDeleteEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDeleteEventCapabilityNode() throws UaException {
        try {
            return this.getDeleteEventCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteEventCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertAnnotationCapability() throws UaException {
        PropertyTypeNode node = this.getInsertAnnotationCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertAnnotationCapability(Boolean value) throws UaException {
        PropertyTypeNode node = this.getInsertAnnotationCapabilityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readInsertAnnotationCapability() throws UaException {
        try {
            return this.readInsertAnnotationCapabilityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeInsertAnnotationCapability(Boolean value) throws UaException {
        try {
            this.writeInsertAnnotationCapabilityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertAnnotationCapabilityAsync() {
        return ((CompletableFuture)this.getInsertAnnotationCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInsertAnnotationCapabilityAsync(Boolean insertAnnotationCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertAnnotationCapability));
        return this.getInsertAnnotationCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInsertAnnotationCapabilityNode() throws UaException {
        try {
            return this.getInsertAnnotationCapabilityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertAnnotationCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertAnnotationCapability", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getServerTimestampSupported() throws UaException {
        PropertyTypeNode node = this.getServerTimestampSupportedNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setServerTimestampSupported(Boolean value) throws UaException {
        PropertyTypeNode node = this.getServerTimestampSupportedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readServerTimestampSupported() throws UaException {
        try {
            return this.readServerTimestampSupportedAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServerTimestampSupported(Boolean value) throws UaException {
        try {
            this.writeServerTimestampSupportedAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readServerTimestampSupportedAsync() {
        return ((CompletableFuture)this.getServerTimestampSupportedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerTimestampSupportedAsync(Boolean serverTimestampSupported) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverTimestampSupported));
        return this.getServerTimestampSupportedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerTimestampSupportedNode() throws UaException {
        try {
            return this.getServerTimestampSupportedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerTimestampSupportedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerTimestampSupported", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public FolderTypeNode getAggregateFunctionsNode() throws UaException {
        try {
            return this.getAggregateFunctionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getAggregateFunctionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateFunctions", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

